/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rebind.context;

import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.resources.rebind.context.StaticResourceContext;

class InlineResourceContext
extends StaticResourceContext {
    public static final int MAX_ENCODED_SIZE = 65535;

    InlineResourceContext(TreeLogger logger, GeneratorContext context, JClassType resourceBundleType) {
        super(logger, context, resourceBundleType);
    }

    public String deploy(String suggestedFileName, String mimeType, byte[] data, boolean xhrCompatible) throws UnableToCompleteException {
        TreeLogger logger = this.getLogger();
        if (!xhrCompatible && data.length < 65536) {
            logger.log(TreeLogger.DEBUG, "Inlining", null);
            String base64Contents = InlineResourceContext.toBase64(data);
            String encoded = "\"data:" + mimeType + ";base64," + base64Contents + "\"";
            if (encoded.length() < 65535) {
                return encoded;
            }
        }
        return super.deploy(suggestedFileName, mimeType, data, true);
    }

    public boolean supportsDataUrls() {
        return true;
    }
}

