/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit.tools;

import com.google.gwt.junit.client.GWTTestCase;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.Test;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWTTestSuite
extends TestSuite {
    private final Map<String, TestSuite> moduleSuites = new TreeMap<String, TestSuite>();
    private TestSuite nonGWTTestSuite;

    public GWTTestSuite() {
    }

    public GWTTestSuite(String name) {
        super(name);
    }

    public void addTest(Test test) {
        if (test instanceof TestSuite) {
            this.doAddTest((TestSuite)test);
        } else {
            this.doAddTest(test);
        }
    }

    private void doAddTest(Test test) {
        TestSuite moduleSuite = this.getModuleSuiteFor(test);
        moduleSuite.addTest(test);
    }

    private void doAddTest(TestSuite suite) {
        TestSuite[] homogenized;
        for (TestSuite test : homogenized = this.homogenize(suite)) {
            this.doAddTest((Test)test);
        }
    }

    private TestSuite getModuleSuiteFor(Test test) {
        GWTTestCase gwtTest;
        String moduleName;
        if (test instanceof TestSuite) {
            TestSuite suite = (TestSuite)test;
            if (suite.countTestCases() == 0) {
                return this.nonGWTTestSuite;
            }
            return this.getModuleSuiteFor(suite.testAt(0));
        }
        if (test instanceof GWTTestCase && (moduleName = (gwtTest = (GWTTestCase)test).getSyntheticModuleName()) != null) {
            TestSuite suite = this.moduleSuites.get(moduleName);
            if (suite == null) {
                suite = new TestSuite(moduleName + ".gwt.xml");
                this.moduleSuites.put(moduleName, suite);
                super.addTest((Test)suite);
            }
            return suite;
        }
        if (this.nonGWTTestSuite == null) {
            this.nonGWTTestSuite = new TestSuite("Non-GWT");
            super.addTest((Test)this.nonGWTTestSuite);
        }
        return this.nonGWTTestSuite;
    }

    private TestSuite[] homogenize(TestSuite suite) {
        String suiteName = suite.getName();
        ArrayList<TestSuite> buckets = new ArrayList<TestSuite>();
        HashMap<TestSuite, TestSuite> moduleToBucket = new HashMap<TestSuite, TestSuite>();
        Enumeration enumeration = suite.tests();
        while (enumeration.hasMoreElements()) {
            Test test = (Test)enumeration.nextElement();
            if (test instanceof TestSuite) {
                TestSuite[] subSuites;
                for (TestSuite subSuite : subSuites = this.homogenize((TestSuite)test)) {
                    this.sortIntoBucket((Test)subSuite, buckets, moduleToBucket, suiteName);
                }
                continue;
            }
            this.sortIntoBucket(test, buckets, moduleToBucket, suiteName);
        }
        int numBuckets = buckets.size();
        if (numBuckets == 1) {
            return new TestSuite[]{suite};
        }
        return buckets.toArray(new TestSuite[numBuckets]);
    }

    private void sortIntoBucket(Test test, List<TestSuite> buckets, Map<TestSuite, TestSuite> moduleToBucket, String newBucketName) {
        TestSuite module = this.getModuleSuiteFor(test);
        TestSuite bucket = moduleToBucket.get(module);
        if (bucket == null) {
            bucket = new TestSuite(newBucketName);
            buckets.add(bucket);
            moduleToBucket.put(module, bucket);
        }
        bucket.addTest(test);
    }
}

