/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit.server;

import com.google.gwt.dev.util.JsniRef;
import com.google.gwt.dev.util.StringKey;
import com.google.gwt.junit.JUnitFatalLaunchException;
import com.google.gwt.junit.JUnitMessageQueue;
import com.google.gwt.junit.JUnitShell;
import com.google.gwt.junit.client.TimeoutException;
import com.google.gwt.junit.client.impl.ExceptionWrapper;
import com.google.gwt.junit.client.impl.JUnitHost;
import com.google.gwt.junit.client.impl.JUnitResult;
import com.google.gwt.junit.client.impl.StackTraceWrapper;
import com.google.gwt.user.client.rpc.InvocationException;
import com.google.gwt.user.server.rpc.HybridServiceServlet;
import com.google.gwt.user.server.rpc.RPCServletUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitHostImpl
extends HybridServiceServlet
implements JUnitHost {
    private static JUnitMessageQueue sHost = null;
    private static final int TIME_TO_WAIT_FOR_TESTNAME = 300000;
    private static final AtomicInteger uniqueSessionId = new AtomicInteger();
    private Map<StrongName, Map<SymbolName, String>> symbolMaps = new HashMap<StrongName, Map<SymbolName, String>>();

    private static synchronized JUnitMessageQueue getHost() {
        if (sHost == null && (sHost = JUnitShell.getMessageQueue()) == null) {
            throw new InvocationException("Unable to find JUnitShell; is this servlet running under GWTTestCase?");
        }
        return sHost;
    }

    private static <T> void setField(Class<T> cls, String fieldName, T obj, Object value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field fld = cls.getDeclaredField(fieldName);
        fld.setAccessible(true);
        fld.set(obj, value);
    }

    @Override
    public JUnitHost.InitialResponse getTestBlock(int blockIndex, JUnitHost.ClientInfo clientInfo) throws TimeoutException {
        JUnitMessageQueue.ClientInfoExt clientInfoExt = clientInfo.getSessionId() < 0 ? this.createNewClientInfo(clientInfo.getUserAgent()) : this.createClientInfo(clientInfo);
        JUnitHost.TestBlock initialTestBlock = JUnitHostImpl.getHost().getTestBlock(clientInfoExt, blockIndex, 300000L);
        return new JUnitHost.InitialResponse(clientInfoExt.getSessionId(), initialTestBlock);
    }

    @Override
    public JUnitHost.TestBlock reportResultsAndGetTestBlock(HashMap<JUnitHost.TestInfo, JUnitResult> results, int testBlock, JUnitHost.ClientInfo clientInfo) throws TimeoutException {
        for (JUnitResult result : results.values()) {
            this.initResult(this.getThreadLocalRequest(), result);
            ExceptionWrapper ew = result.getExceptionWrapper();
            result.setException(this.deserialize(ew));
        }
        JUnitMessageQueue host = JUnitHostImpl.getHost();
        JUnitMessageQueue.ClientInfoExt clientInfoExt = this.createClientInfo(clientInfo);
        host.reportResults(clientInfoExt, results);
        return host.getTestBlock(clientInfoExt, testBlock, 300000L);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestURI = request.getRequestURI();
        if (requestURI.endsWith("/junithost/loadError")) {
            String requestPayload = RPCServletUtils.readContentAsUtf8(request);
            JUnitResult result = new JUnitResult();
            this.initResult(request, result);
            result.setException(new JUnitFatalLaunchException(requestPayload));
            JUnitHostImpl.getHost().reportFatalLaunch(this.createNewClientInfo(null), result);
        } else {
            super.service(request, response);
        }
    }

    private JUnitMessageQueue.ClientInfoExt createClientInfo(JUnitHost.ClientInfo clientInfo) {
        assert (clientInfo.getSessionId() >= 0);
        return new JUnitMessageQueue.ClientInfoExt(clientInfo.getSessionId(), clientInfo.getUserAgent(), this.getClientDesc(this.getThreadLocalRequest()));
    }

    private JUnitMessageQueue.ClientInfoExt createNewClientInfo(String userAgent) {
        return new JUnitMessageQueue.ClientInfoExt(this.createSessionId(), userAgent, this.getClientDesc(this.getThreadLocalRequest()));
    }

    private int createSessionId() {
        return uniqueSessionId.getAndIncrement();
    }

    private Throwable deserialize(ExceptionWrapper ew) {
        if (ew == null) {
            return null;
        }
        Throwable ex = null;
        Throwable cause = this.deserialize(ew.cause);
        try {
            Class<?> exClass = Class.forName(ew.typeName);
            try {
                Constructor<?> ctor = exClass.getDeclaredConstructor(String.class, Throwable.class);
                ctor.setAccessible(true);
                ex = (Throwable)ctor.newInstance(ew.message, cause);
            }
            catch (Throwable e) {
                try {
                    Constructor<?> ctor = exClass.getDeclaredConstructor(String.class);
                    ctor.setAccessible(true);
                    ex = (Throwable)ctor.newInstance(ew.message);
                    ex.initCause(cause);
                }
                catch (Throwable e2) {
                    try {
                        Constructor<?> ctor = exClass.getDeclaredConstructor(Throwable.class);
                        ctor.setAccessible(true);
                        ex = (Throwable)ctor.newInstance(cause);
                        JUnitHostImpl.setField(Throwable.class, "detailMessage", ex, ew.message);
                    }
                    catch (Throwable e3) {
                        try {
                            Constructor<?> ctor = exClass.getDeclaredConstructor(new Class[0]);
                            ctor.setAccessible(true);
                            ex = (Throwable)ctor.newInstance(new Object[0]);
                            ex.initCause(cause);
                            JUnitHostImpl.setField(Throwable.class, "detailMessage", ex, ew.message);
                        }
                        catch (Throwable e4) {
                            this.log("Failed to deserialize getException of type '" + ew.typeName + "'; no available constructor", e4);
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            this.log("Failed to deserialize getException of type '" + ew.typeName + "'", e);
        }
        if (ex == null) {
            ex = new RuntimeException(ew.typeName + ": " + ew.message, cause);
        }
        ex.setStackTrace(this.deserialize(ew.stackTrace));
        return ex;
    }

    private StackTraceElement deserialize(StackTraceWrapper stw) {
        StackTraceElement ste = null;
        Object[] args = this.resymbolize(stw);
        try {
            try {
                Constructor ctor = StackTraceElement.class.getDeclaredConstructor(String.class, String.class, String.class, Integer.TYPE);
                ctor.setAccessible(true);
                ste = (StackTraceElement)ctor.newInstance(args);
            }
            catch (NoSuchMethodException e) {
                Constructor ctor = StackTraceElement.class.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                ste = (StackTraceElement)ctor.newInstance(new Object[0]);
                JUnitHostImpl.setField(StackTraceElement.class, "declaringClass", ste, args[0]);
                JUnitHostImpl.setField(StackTraceElement.class, "methodName", ste, args[1]);
                JUnitHostImpl.setField(StackTraceElement.class, "fileName", ste, args[2]);
                JUnitHostImpl.setField(StackTraceElement.class, "lineNumber", ste, args[3]);
            }
        }
        catch (Throwable e) {
            this.log("Error creating stack trace", e);
        }
        return ste;
    }

    private StackTraceElement[] deserialize(StackTraceWrapper[] stackTrace) {
        int len = stackTrace.length;
        StackTraceElement[] result = new StackTraceElement[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.deserialize(stackTrace[i]);
        }
        return result;
    }

    private String getClientDesc(HttpServletRequest request) {
        String machine = request.getRemoteHost();
        String agent = request.getHeader("User-Agent");
        return machine + " / " + agent;
    }

    private void initResult(HttpServletRequest request, JUnitResult result) {
        String agent = request.getHeader("User-Agent");
        result.setAgent(agent);
        String machine = request.getRemoteHost();
        result.setHost(machine);
    }

    private synchronized Map<SymbolName, String> loadSymbolMap(StrongName strongName) {
        Map<SymbolName, String> toReturn = this.symbolMaps.get((Object)strongName);
        if (toReturn != null) {
            return toReturn;
        }
        toReturn = new HashMap<SymbolName, String>();
        String path = this.getRequestModuleBasePath() + "/.junit_symbolMaps/" + strongName.get() + ".symbolMap";
        InputStream in = this.getServletContext().getResourceAsStream(path);
        if (in == null) {
            this.symbolMaps.put(strongName, null);
            return null;
        }
        BufferedReader bin = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while ((line = bin.readLine()) != null) {
                if (line.charAt(0) == '#') continue;
                int idx = line.indexOf(44);
                toReturn.put(new SymbolName(line.substring(0, idx)), line.substring(idx + 1));
            }
        }
        catch (IOException e) {
            toReturn = null;
        }
        this.symbolMaps.put(strongName, toReturn);
        return toReturn;
    }

    private Object[] resymbolize(StackTraceWrapper stw) {
        Object[] toReturn;
        String symbolData;
        StrongName strongName = new StrongName(this.getPermutationStrongName());
        Map<SymbolName, String> map = this.loadSymbolMap(strongName);
        String string = symbolData = map == null ? null : map.get((Object)new SymbolName(stw.methodName));
        if (symbolData != null) {
            String[] parts = symbolData.split(",");
            assert (parts.length == 5) : "Expected 5, have " + parts.length;
            JsniRef ref = JsniRef.parse((String)parts[0].substring(0, parts[0].lastIndexOf(41) + 1));
            toReturn = new Object[]{ref.className(), ref.memberName(), stw.fileName, stw.lineNumber};
        } else {
            toReturn = new Object[]{stw.className, stw.methodName, stw.fileName, stw.lineNumber};
        }
        return toReturn;
    }

    private static class StrongName
    extends StringKey {
        protected StrongName(String value) {
            super(value);
        }
    }

    private static class SymbolName
    extends StringKey {
        protected SymbolName(String value) {
            super(value);
        }
    }
}

