/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit.remote;

import com.google.gwt.junit.remote.BrowserManagerServer;
import com.google.gwt.util.tools.ArgHandler;
import com.google.gwt.util.tools.ArgHandlerFlag;
import com.google.gwt.util.tools.ArgHandlerString;
import com.google.gwt.util.tools.ToolBase;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class BrowserManagerServerLauncher
extends ToolBase {
    private static final Logger logger = Logger.getLogger(BrowserManagerServerLauncher.class.getName());
    private static final String USAGE = "Manages local browser windows for a remote client using RMI.\n\nPass in an even number of args, at least 2. The first argument\nis a short registration name, and the second argument is the\nexecutable to run when that name is used; for example,\n\n\tie6 \"C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE\"\n\nwould register Internet Explorer to \"rmi://localhost/ie6\".\nThe third and fourth arguments make another pair, and so on.\n";
    private List<BMSEntry> bmsList = new ArrayList<BMSEntry>();
    private int portArg = 1099;
    private boolean serializeArg = false;

    BrowserManagerServerLauncher() {
        this.registerHandler((ArgHandler)new ArgHandlerPort());
        this.registerHandler(new ArgHandlerRegistration());
        this.registerHandler((ArgHandler)new ArgHandlerFlag(){

            public String getPurpose() {
                return "Queue up requests to a single server so that only a single test runs at a time (Usefule for a simple Firefox setup.)\n";
            }

            public String getTag() {
                return "-serialize";
            }

            public boolean setFlag() {
                BrowserManagerServerLauncher.this.serializeArg = true;
                return true;
            }
        });
    }

    public boolean doProcessArgs(String[] args) {
        if (args.length == 0) {
            System.err.println(USAGE);
            return false;
        }
        return this.processArgs(args);
    }

    public void run() {
        Registry rmiRegistry = null;
        try {
            rmiRegistry = LocateRegistry.createRegistry(this.portArg);
        }
        catch (RemoteException e) {
            logger.log(Level.SEVERE, "Couldn't bind RMI Registry to port " + this.portArg, e);
            System.exit(1);
        }
        logger.log(Level.ALL, "RMI registry ready on port " + this.portArg + ".");
        for (BMSEntry entry : this.bmsList) {
            BrowserManagerServer server = null;
            try {
                server = new BrowserManagerServer(entry.browserPath, this.serializeArg);
            }
            catch (RemoteException re) {
                logger.log(Level.SEVERE, entry.registrationKey + ": Error starting new BrowserManagerServer.", re);
                System.exit(2);
            }
            try {
                rmiRegistry.rebind(entry.registrationKey, server);
            }
            catch (RemoteException re) {
                logger.log(Level.SEVERE, entry.registrationKey + " server: " + server + " port: " + this.portArg + " Error on rebind to " + entry.registrationKey, re);
                System.exit(3);
            }
            logger.log(Level.INFO, "Server: " + entry.registrationKey + " started and awaiting connections.");
        }
        logger.log(Level.INFO, "All servers started.");
    }

    protected String getDescription() {
        return USAGE;
    }

    private final class ArgHandlerPort
    extends ArgHandlerString {
        private ArgHandlerPort() {
        }

        public String getPurpose() {
            return "Controls the port for the RMI invocation (defaults to 1099)";
        }

        public String getTag() {
            return "-port";
        }

        public String[] getTagArgs() {
            return new String[]{"port-number"};
        }

        public boolean isRequired() {
            return false;
        }

        public boolean setString(String value) {
            try {
                BrowserManagerServerLauncher.this.portArg = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                logger.severe("The -port argument must be an integer value.  Got: " + value);
                return false;
            }
            return true;
        }
    }

    private class ArgHandlerRegistration
    extends ArgHandler {
        private ArgHandlerRegistration() {
        }

        public String getPurpose() {
            return "Specify two arguments: a registration id used for the RMI call and the browser launch command";
        }

        public String getTag() {
            return null;
        }

        public String[] getTagArgs() {
            return new String[]{"registration-id", "path-to-browser-executable"};
        }

        public int handle(String[] args, int startIndex) {
            if (args.length >= startIndex + 2) {
                BMSEntry entry = new BMSEntry(args[startIndex], args[startIndex + 1]);
                BrowserManagerServerLauncher.this.bmsList.add(entry);
                return 1;
            }
            return -1;
        }

        public boolean isRequired() {
            return true;
        }
    }

    private static class BMSEntry {
        final String browserPath;
        final String registrationKey;

        BMSEntry(String registrationKeyIn, String browserPathIn) {
            this.registrationKey = registrationKeyIn;
            this.browserPath = browserPathIn;
        }
    }
}

