/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.junit.JUnitShell;
import com.google.gwt.junit.RunStyle;
import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RunStyleSelenium
extends RunStyle {
    private Set<String> interruptedHosts;
    private SeleniumWrapper[] remotes;
    private final Object wasInterruptedLock = new Object();

    public RunStyleSelenium(JUnitShell shell) {
        super(shell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getInterruptedHosts() {
        Object object = this.wasInterruptedLock;
        synchronized (object) {
            if (this.interruptedHosts == null) {
                return null;
            }
            return this.interruptedHosts.toArray(new String[this.interruptedHosts.size()]);
        }
    }

    public int initialize(String args) {
        if (args == null || args.length() == 0) {
            this.getLogger().log(TreeLogger.ERROR, "Selenium runstyle requires comma-separated Selenium-RC targets");
            return -1;
        }
        String[] targetsIn = args.split(",");
        SeleniumWrapper[] targets = new SeleniumWrapper[targetsIn.length];
        for (int i = 0; i < targets.length; ++i) {
            try {
                targets[i] = this.createSeleniumWrapper(targetsIn[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(TreeLogger.ERROR, e.getMessage());
                return -1;
            }
        }
        this.remotes = targets;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                for (SeleniumWrapper remote : RunStyleSelenium.this.remotes) {
                    if (remote.getSelenium() == null) continue;
                    try {
                        remote.getSelenium().stop();
                    }
                    catch (SeleniumException se) {
                        RunStyleSelenium.this.shell.getTopLogger().log(TreeLogger.WARN, "Error stopping selenium session", (Throwable)se);
                    }
                }
            }
        });
        this.start();
        return targets.length;
    }

    public synchronized void launchModule(String moduleName) {
        String domain = "http://" + this.getLocalHostName() + ":" + this.shell.getPort() + "/";
        for (SeleniumWrapper remote : this.remotes) {
            try {
                String url = this.shell.getModuleUrl(moduleName);
                this.shell.getTopLogger().log(TreeLogger.TRACE, "Starting with domain: " + domain + " Opening URL: " + url);
                remote.createSelenium(domain);
                remote.getSelenium().start();
                remote.getSelenium().open(url);
            }
            catch (Exception e) {
                this.shell.getTopLogger().log(TreeLogger.ERROR, "Error launching browser via Selenium-RC at " + remote.getSpecifier(), (Throwable)e);
            }
        }
    }

    protected SeleniumWrapper createSeleniumWrapper(String seleniumSpecifier) {
        return new RCSelenium(seleniumSpecifier);
    }

    protected void start() {
        Thread keepAliveThread = new Thread(){

            public void run() {
                do {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (RunStyleSelenium.this.doKeepAlives());
            }
        };
        keepAliveThread.setDaemon(true);
        keepAliveThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean doKeepAlives() {
        if (this.remotes != null) {
            for (SeleniumWrapper remote : this.remotes) {
                try {
                    if (remote.getSelenium() == null) continue;
                    remote.getSelenium().getTitle();
                }
                catch (Throwable e) {
                    Object object = this.wasInterruptedLock;
                    synchronized (object) {
                        if (this.interruptedHosts == null) {
                            this.interruptedHosts = new HashSet<String>();
                        }
                        this.interruptedHosts.add(remote.getSpecifier());
                    }
                }
            }
        }
        return this.interruptedHosts == null;
    }

    static class RCSelenium
    implements SeleniumWrapper {
        private static final Pattern PATTERN = Pattern.compile("([\\w\\.-]+):([\\d]+)/(.+)");
        String browser;
        String host;
        int port;
        private Selenium selenium;
        private final String specifier;

        public RCSelenium(String specifier) {
            this.specifier = specifier;
            this.parseSpecifier();
        }

        public void createSelenium(String domain) {
            this.selenium = new DefaultSelenium(this.host, this.port, this.browser, domain);
        }

        public Selenium getSelenium() {
            return this.selenium;
        }

        public String getSpecifier() {
            return this.specifier;
        }

        private void parseSpecifier() {
            Matcher matcher = PATTERN.matcher(this.specifier);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Unable to parse Selenium target " + this.specifier + " (expected format is [host]:[port]/[browser])");
            }
            this.browser = matcher.group(3);
            this.host = matcher.group(1);
            this.port = Integer.parseInt(matcher.group(2));
        }
    }

    protected static interface SeleniumWrapper {
        public void createSelenium(String var1);

        public Selenium getSelenium();

        public String getSpecifier();
    }
}

