/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit;

import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.cfg.Condition;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.Properties;
import com.google.gwt.dev.util.Util;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.gwt.junit.client.WithProperties;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.TestCase;

public class PropertyDefiningStrategy
extends GWTTestCase.BaseStrategy {
    private TestCase testCase;
    private Set<WithProperties.Property> properties;

    public PropertyDefiningStrategy(TestCase testCase) {
        this.testCase = testCase;
    }

    protected String getBaseModuleExtension() {
        return super.getSyntheticModuleExtension();
    }

    public String getSyntheticModuleExtension() {
        String extension = this.getBaseModuleExtension();
        this.computePropertiesMap();
        if (this.properties.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (WithProperties.Property property : this.properties) {
                sb.append(".").append(property.name()).append("$").append(property.value());
            }
            extension = extension + sb.toString();
        }
        return extension;
    }

    public void processModule(ModuleDef module) {
        super.processModule(module);
        this.computePropertiesMap();
        if (this.properties.size() > 0) {
            Properties props = module.getProperties();
            for (WithProperties.Property property : this.properties) {
                BindingProperty binding = props.createBinding(property.name());
                if (!binding.isDefinedValue(property.value())) {
                    binding.addDefinedValue((Condition)binding.getRootCondition(), property.value());
                }
                binding.setAllowedValues((Condition)binding.getRootCondition(), new String[]{property.value()});
            }
        }
    }

    private WithProperties.Property checkProperty(WithProperties.Property property) {
        String[] tokens = (property.name() + ". ").split("\\.");
        for (int i = 0; i < tokens.length - 1; ++i) {
            if (!Util.isValidJavaIdent((String)tokens[i])) {
                throw new AssertionError((Object)("Property name invalid: " + property.name()));
            }
        }
        if (!Util.isValidJavaIdent((String)property.value())) {
            throw new AssertionError((Object)("Property value invalid: " + property.value()));
        }
        return property;
    }

    private void computePropertiesMap() {
        if (this.properties == null) {
            TreeSet<WithProperties.Property> props = new TreeSet<WithProperties.Property>(new Comparator<WithProperties.Property>(){

                @Override
                public int compare(WithProperties.Property p1, WithProperties.Property p2) {
                    int r = p1.name().compareTo(p2.name());
                    if (r == 0) {
                        r = p1.value().compareTo(p2.value());
                    }
                    return r;
                }
            });
            try {
                Method testMethod;
                String name = this.testCase.getName();
                if (name != null && (testMethod = this.testCase.getClass().getMethod(this.testCase.getName(), new Class[0])).isAnnotationPresent(WithProperties.class)) {
                    WithProperties annotation = testMethod.getAnnotation(WithProperties.class);
                    for (WithProperties.Property property : annotation.value()) {
                        props.add(this.checkProperty(property));
                    }
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            this.properties = props;
        }
    }
}

