/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.json.client;

import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONBoolean;
import com.google.gwt.json.client.JSONException;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;

public class JSONParser {
    static final JavaScriptObject typeMap = JSONParser.initTypeMap();

    public static JSONValue parse(String jsonString) {
        if (jsonString == null) {
            throw new NullPointerException();
        }
        if (jsonString.length() == 0) {
            throw new IllegalArgumentException("empty argument");
        }
        try {
            return JSONParser.evaluate(jsonString);
        }
        catch (JavaScriptException ex) {
            throw new JSONException(ex);
        }
    }

    static void throwUnknownTypeException(String typeString) {
        throw new JSONException("Unexpected typeof result '" + typeString + "'; please report this bug to the GWT team");
    }

    private static JSONValue createBoolean(boolean v) {
        return JSONBoolean.getInstance(v);
    }

    private static JSONValue createNumber(double v) {
        return new JSONNumber(v);
    }

    private static native JSONValue createObject(Object var0);

    private static JSONValue createString(String v) {
        return new JSONString(v);
    }

    private static JSONValue createUndefined() {
        return null;
    }

    private static native JSONValue evaluate(String var0);

    private static native JavaScriptObject initTypeMap();

    private JSONParser() {
    }
}

