/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.tools;

import com.google.gwt.i18n.client.Constants;
import com.google.gwt.i18n.client.ConstantsWithLookup;
import com.google.gwt.i18n.client.Localizable;
import com.google.gwt.i18n.client.Messages;
import com.google.gwt.i18n.tools.ArgHandlerValueChooser;
import com.google.gwt.user.tools.util.ArgHandlerEclipse;
import com.google.gwt.user.tools.util.ArgHandlerIgnore;
import com.google.gwt.user.tools.util.ArgHandlerOverwrite;
import com.google.gwt.util.tools.ArgHandler;
import com.google.gwt.util.tools.ArgHandlerExtra;
import com.google.gwt.util.tools.ArgHandlerOutDir;
import com.google.gwt.util.tools.ToolBase;
import com.google.gwt.util.tools.Utility;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class I18NCreator
extends ToolBase {
    private static final String PACKAGE_PATH;
    private ArgHandlerValueChooser chooser;
    private String eclipse = null;
    private String fullInterfaceName = null;
    private boolean ignore = false;
    private File outDir;
    private boolean overwrite = false;

    public static void main(String[] args) {
        I18NCreator creator = new I18NCreator();
        if (creator.processArgs(args) && creator.run()) {
            return;
        }
        System.exit(1);
    }

    static void createLocalizable(String fullInterfaceName, File outDir, String eclipse, boolean overwrite, boolean ignore, Class<? extends Localizable> interfaceToCreate) throws IOException {
        boolean isWindows;
        String installPath = Utility.getInstallPath();
        String gwtUserPath = installPath + '/' + "gwt-user.jar";
        String gwtDevPath = installPath + '/' + "gwt-dev.jar";
        boolean bl = isWindows = gwtDevPath.substring(gwtDevPath.lastIndexOf(47) + 1).indexOf("windows") >= 0;
        String basePathEnv = !new File(installPath).isAbsolute() ? (isWindows ? "%~dp0\\" : "$APPDIR/") : "";
        int pos = fullInterfaceName.lastIndexOf(46);
        String clientPackageName = fullInterfaceName.substring(0, pos);
        String interfaceName = fullInterfaceName.substring(pos + 1);
        pos = clientPackageName.lastIndexOf(46);
        File clientDir = Utility.getDirectory((File)outDir, (String)"src", (boolean)true);
        if (pos >= 0) {
            String clientPackage = clientPackageName.replace('.', '/');
            clientDir = Utility.getDirectory((File)clientDir, (String)clientPackage, (boolean)true);
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("@className", fullInterfaceName);
        replacements.put("@shortClassName", interfaceName);
        replacements.put("@gwtUserPath", basePathEnv + gwtUserPath);
        replacements.put("@gwtDevPath", basePathEnv + gwtDevPath);
        replacements.put("@compileClass", "com.google.gwt.dev.GWTCompiler");
        replacements.put("@i18nClass", "com.google.gwt.i18n.tools.I18NSync");
        String templateData = null;
        if (Messages.class == interfaceToCreate) {
            replacements.put("@createMessages", "-createMessages");
            templateData = Utility.getFileFromClassPath((String)(PACKAGE_PATH + "i18nMessages.propertiessrc"));
        } else {
            if (ConstantsWithLookup.class == interfaceToCreate) {
                replacements.put("@createMessages", "-createConstantsWithLookup");
            } else if (Constants.class == interfaceToCreate) {
                replacements.put("@createMessages", "");
            } else {
                throw new RuntimeException("Internal Error: Unable to create i18n class derived from " + interfaceToCreate.getName());
            }
            templateData = Utility.getFileFromClassPath((String)(PACKAGE_PATH + "i18nConstants.propertiessrc"));
        }
        File i18nPropertiesFile = Utility.createNormalFile((File)clientDir, (String)(interfaceName + ".properties"), (boolean)overwrite, (boolean)ignore);
        if (i18nPropertiesFile != null && templateData != null) {
            Utility.writeTemplateFile((File)i18nPropertiesFile, (String)templateData, replacements);
        }
        if (eclipse != null) {
            replacements.put("@projectName", eclipse);
            File updateLaunchConfig = Utility.createNormalFile((File)outDir, (String)(interfaceName + "-i18n" + ".launch"), (boolean)overwrite, (boolean)ignore);
            if (updateLaunchConfig != null) {
                String out = Utility.getFileFromClassPath((String)(PACKAGE_PATH + "I18N-update.launchsrc"));
                Utility.writeTemplateFile((File)updateLaunchConfig, (String)out, replacements);
            }
        }
        String extension = isWindows ? ".cmd" : "";
        File gwti18n = Utility.createNormalFile((File)outDir, (String)(interfaceName + "-i18n" + extension), (boolean)overwrite, (boolean)ignore);
        if (gwti18n != null) {
            String out = Utility.getFileFromClassPath((String)(PACKAGE_PATH + "gwti18n" + extension + "src"));
            Utility.writeTemplateFile((File)gwti18n, (String)out, replacements);
            if (extension.length() == 0) {
                Runtime.getRuntime().exec("chmod u+x " + gwti18n.getAbsolutePath());
            }
        }
    }

    protected I18NCreator() {
        this.registerHandler((ArgHandler)new ArgHandlerEclipse(){

            public String getPurpose() {
                return "Creates a i18n update launch config for the named eclipse project";
            }

            public boolean setString(String str) {
                I18NCreator.this.eclipse = str;
                return true;
            }
        });
        this.registerHandler((ArgHandler)new ArgHandlerOutDir(){

            public void setDir(File dir) {
                I18NCreator.this.outDir = dir;
            }
        });
        this.registerHandler((ArgHandler)new ArgHandlerOverwrite(){

            public boolean setFlag() {
                if (I18NCreator.this.ignore) {
                    System.err.println("-overwrite cannot be used with -ignore.");
                    return false;
                }
                I18NCreator.this.overwrite = true;
                return true;
            }
        });
        this.chooser = new ArgHandlerValueChooser();
        this.registerHandler(this.chooser.getConstantsWithLookupArgHandler());
        this.registerHandler(this.chooser.getMessagesArgHandler());
        this.registerHandler((ArgHandler)new ArgHandlerIgnore(){

            public boolean setFlag() {
                if (I18NCreator.this.overwrite) {
                    System.err.println("-ignore cannot be used with -overwrite.");
                    return false;
                }
                I18NCreator.this.ignore = true;
                return true;
            }
        });
        this.registerHandler((ArgHandler)new ArgHandlerClassName());
    }

    protected boolean run() {
        try {
            I18NCreator.createLocalizable(this.fullInterfaceName, this.outDir, this.eclipse, this.overwrite, this.ignore, this.chooser.getArgValue());
            return true;
        }
        catch (IOException e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            return false;
        }
    }

    static {
        String path = I18NCreator.class.getName();
        path = path.substring(0, path.lastIndexOf(46) + 1);
        PACKAGE_PATH = path.replace('.', '/');
    }

    protected class ArgHandlerClassName
    extends ArgHandlerExtra {
        protected ArgHandlerClassName() {
        }

        public boolean addExtraArg(String arg) {
            if (I18NCreator.this.fullInterfaceName != null) {
                System.err.println("Too many arguments.");
                return false;
            }
            if (!arg.matches("[\\w\\$]+(\\.[\\w\\$]+)+")) {
                System.err.println("'" + arg + "' does not appear to be a valid fully-qualified Java class name.");
                return false;
            }
            if (arg.indexOf(36) != -1) {
                System.err.println("'" + arg + "': This version of the tool does not support nested classes");
                return false;
            }
            String[] parts = arg.split("\\.");
            if (parts.length < 2) {
                System.err.println("'" + arg + "': Cannot live in the root package. Please specify a package.");
                return false;
            }
            I18NCreator.this.fullInterfaceName = arg;
            return true;
        }

        public String getPurpose() {
            return "The fully qualified name of the interface to create";
        }

        public String[] getTagArgs() {
            return new String[]{"interfaceName"};
        }

        public boolean isRequired() {
            return true;
        }
    }
}

