/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.i18n.rebind.AbstractResource;
import com.google.gwt.i18n.rebind.ConstantsWithLookupImplCreator;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.user.rebind.AbstractGeneratorClassCreator;
import com.google.gwt.user.rebind.AbstractMethodCreator;
import com.google.gwt.user.rebind.AbstractSourceCreator;
import java.text.MessageFormat;

class LookupMethodCreator
extends AbstractMethodCreator {
    private JType returnType;

    public LookupMethodCreator(AbstractGeneratorClassCreator classCreator, JType returnType) {
        super(classCreator);
        this.returnType = returnType;
    }

    public void createMethodFor(TreeLogger logger, JMethod targetMethod, String key, AbstractResource.ResourceList resourceList, GwtLocale locale) {
        this.createMethodFor(targetMethod);
    }

    protected String getReturnTypeName() {
        JPrimitiveType s = this.returnType.isPrimitive();
        String type = s != null ? AbstractSourceCreator.getJavaObjectTypeFor(s) : this.returnType.getParameterizedQualifiedSourceName();
        return type;
    }

    void createMethodFor(JMethod targetMethod) {
        JParameter[] args = targetMethod.getParameters();
        if (args.length != 1) {
            throw new IllegalStateException("ConstantsWithLookup methods must have exactly one argument");
        }
        String arg0 = args[0].getName();
        String template = "{0} target = ({0}) cache.get(" + arg0 + ");";
        String returnTypeName = this.getReturnTypeName();
        String lookup = MessageFormat.format(template, returnTypeName);
        this.println(lookup);
        this.println("if (target != null) {");
        this.indent();
        this.printReturnTarget();
        this.outdent();
        this.println("}");
        JMethod[] methods = ((ConstantsWithLookupImplCreator)this.currentCreator).allInterfaceMethods;
        JType erasedType = this.returnType.getErasedType();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getReturnType().getErasedType().equals((Object)erasedType) || methods[i] == targetMethod) continue;
            String methodName = methods[i].getName();
            String body = "if(" + arg0 + ".equals(" + LookupMethodCreator.wrap(methodName) + ")) {";
            this.println(body);
            this.indent();
            this.printFound(methodName);
            this.outdent();
            this.println("}");
        }
        String format = "throw new java.util.MissingResourceException(\"Cannot find constant ''\" +{0} + \"''; expecting a method name\", \"{1}\", {0});";
        String result = MessageFormat.format(format, arg0, this.currentCreator.getTarget().getQualifiedSourceName());
        this.println(result);
    }

    void printFound(String methodName) {
        this.println(MessageFormat.format(this.returnTemplate(), methodName));
    }

    void printReturnTarget() {
        this.println("return target;");
    }

    String returnTemplate() {
        return "return {0}();";
    }
}

