/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.i18n.client.impl.ConstantMap;
import com.google.gwt.i18n.rebind.AbstractLocalizableMethodCreator;
import com.google.gwt.i18n.rebind.AbstractResource;
import com.google.gwt.i18n.rebind.ConstantsStringArrayMethodCreator;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.user.rebind.AbstractGeneratorClassCreator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class ConstantsMapMethodCreator
extends AbstractLocalizableMethodCreator {
    static final String GENERIC_STRING_MAP_TYPE = "java.util.Map<java.lang.String, java.lang.String>";

    public ConstantsMapMethodCreator(AbstractGeneratorClassCreator classCreator) {
        super(classCreator);
    }

    public void createMethodFor(TreeLogger logger, JMethod method, String mapName, AbstractResource.ResourceList resourceList, GwtLocale locale) {
        String keyString;
        String methodName = method.getName();
        if (method.getParameters().length > 0) {
            ConstantsMapMethodCreator.error(logger, methodName + " cannot have parameters; extend Messages instead if you need to create " + "parameterized messages");
        }
        this.enableCache();
        String constantMapClassName = ConstantMap.class.getCanonicalName();
        this.println("java.util.Map<java.lang.String, java.lang.String> args = (java.util.Map<java.lang.String, java.lang.String>) cache.get(" + ConstantsMapMethodCreator.wrap(methodName) + ");");
        this.println("if (args == null) {");
        this.indent();
        this.println("args = new " + constantMapClassName + "(new String[] {");
        try {
            keyString = resourceList.getRequiredStringExt(mapName, null);
        }
        catch (AbstractResource.MissingResourceException e) {
            e.setDuring("getting key list");
            throw e;
        }
        String[] keys = ConstantsStringArrayMethodCreator.split(keyString);
        AbstractResource.ResourceList resources = this.getResources();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String key : keys) {
            if (key.length() == 0) continue;
            try {
                String value = resources.getRequiredString(key);
                map.put(key, value);
            }
            catch (AbstractResource.MissingResourceException e) {
                e.setDuring("implementing map");
                throw e;
            }
        }
        this.indent();
        this.indent();
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            this.println(ConstantsMapMethodCreator.wrap((String)entry.getKey()) + ", ");
        }
        this.outdent();
        this.println("},");
        this.indent();
        this.println("new String[] {");
        for (Map.Entry entry : entries) {
            this.println(ConstantsMapMethodCreator.wrap((String)entry.getValue()) + ", ");
        }
        this.outdent();
        this.println("});");
        this.outdent();
        this.println("cache.put(" + ConstantsMapMethodCreator.wrap(methodName) + ", args);");
        this.outdent();
        this.println("};");
        this.println("return args;");
    }
}

