/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.benchmarks;

import com.google.gwt.benchmarks.MetaData;
import com.google.gwt.benchmarks.client.impl.BenchmarkResults;
import com.google.gwt.benchmarks.client.impl.Trial;
import com.google.gwt.benchmarks.rebind.BenchmarkGenerator;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.dev.util.Util;
import com.google.gwt.util.tools.Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.BreakIterator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BenchmarkReport {
    private Parser parser = new Parser();
    private Map<String, Map<String, MetaData>> testMetaData = new HashMap<String, Map<String, MetaData>>();
    private Map<TestCase, List<BenchmarkResults>> testResults = new HashMap<TestCase, List<BenchmarkResults>>();

    private static File findSourceFile(JClassType clazz) {
        char separator = File.separator.charAt(0);
        String filePath = clazz.getPackage().getName().replace('.', separator) + separator + clazz.getSimpleSourceName() + ".java";
        String[] paths = BenchmarkReport.getClassPath();
        for (int i = 0; i < paths.length; ++i) {
            File maybeSourceFile = new File(paths[i] + separator + filePath);
            if (!maybeSourceFile.exists()) continue;
            return maybeSourceFile;
        }
        return null;
    }

    private static String[] getClassPath() {
        String path = System.getProperty("java.class.path");
        return path.split(File.pathSeparator);
    }

    public void addBenchmark(TreeLogger logger, JClassType benchmarkClass) {
        Map<String, JMethod> zeroArgMethods = BenchmarkGenerator.getNotOverloadedTestMethods(benchmarkClass);
        Map<String, JMethod> parameterizedMethods = BenchmarkGenerator.getParameterizedTestMethods(benchmarkClass, TreeLogger.NULL);
        ArrayList<JMethod> testMethods = new ArrayList<JMethod>(zeroArgMethods.size() + parameterizedMethods.size());
        testMethods.addAll(zeroArgMethods.values());
        testMethods.addAll(parameterizedMethods.values());
        Map<String, MetaData> metaDataMap = this.testMetaData.get(benchmarkClass.toString());
        if (metaDataMap == null) {
            metaDataMap = new HashMap<String, MetaData>();
            this.testMetaData.put(benchmarkClass.toString(), metaDataMap);
        }
        for (JMethod method : testMethods) {
            String methodName = method.getName();
            String methodSource = this.parser.getMethod(logger, method);
            StringBuffer sourceBuffer = methodSource == null ? null : new StringBuffer(methodSource);
            StringBuffer summary = new StringBuffer();
            StringBuffer comment = new StringBuffer();
            this.getComment(sourceBuffer, summary, comment);
            MetaData metaData = new MetaData(benchmarkClass.toString(), methodName, sourceBuffer != null ? sourceBuffer.toString() : null, methodName, summary.toString());
            metaDataMap.put(methodName, metaData);
        }
    }

    public void addBenchmarkResults(TestCase test, BenchmarkResults results) {
        List<BenchmarkResults> currentResults = this.testResults.get(test);
        if (currentResults == null) {
            currentResults = new ArrayList<BenchmarkResults>();
            this.testResults.put(test, currentResults);
        }
        currentResults.add(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(String outputPath) throws ParserConfigurationException, IOException {
        if (this.testResults.size() == 0) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        doc.appendChild(new ReportXml().toElement(doc));
        byte[] xmlBytes = Util.toXmlUtf8((Document)doc);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputPath);
            fos.write(xmlBytes);
        }
        catch (Throwable throwable) {
            Utility.close(fos);
            throw throwable;
        }
        Utility.close((OutputStream)fos);
    }

    private void getComment(StringBuffer sourceCode, StringBuffer summary, StringBuffer comment) {
        if (sourceCode == null) {
            return;
        }
        summary.setLength(0);
        comment.setLength(0);
        String regex = "/\\*\\*(.(?!}-\\*/))*\\*/";
        Pattern p = Pattern.compile(regex, 32);
        Matcher m = p.matcher(sourceCode);
        if (!m.find()) {
            return;
        }
        String commentStr = m.group();
        p = Pattern.compile("(/\\*\\*\\s*)(((\\s*\\**\\s*)([^\n\r]*)[\n\r]+)*)");
        m = p.matcher(commentStr);
        if (!m.find()) {
            return;
        }
        String stripped = m.group(2);
        p = Pattern.compile("^\\p{Blank}*\\**\\p{Blank}*", 8);
        String bareComment = p.matcher(stripped).replaceAll("");
        BreakIterator iterator = BreakIterator.getSentenceInstance();
        iterator.setText(bareComment);
        int firstSentenceEnd = iterator.next();
        if (firstSentenceEnd == -1) {
            summary.append(bareComment);
        } else {
            summary.append(bareComment.substring(0, firstSentenceEnd));
        }
        comment.append(bareComment);
        p = Pattern.compile("[^\\r\\n]+[\\r\\n]+(\\s+)\\*", 8);
        m = p.matcher(sourceCode);
        int indentLen = 0;
        if (m.find()) {
            String indent = m.group(1);
            indentLen = indent.length() - 1;
        }
        StringBuffer leadingIndent = new StringBuffer();
        for (int i = 0; i < indentLen; ++i) {
            leadingIndent.append(' ');
        }
        sourceCode.insert(0, leadingIndent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BenchmarkXml {
        private MetaData metaData;
        private List<BenchmarkResults> results;
        private TestCase test;

        BenchmarkXml(TestCase test, List<BenchmarkResults> results) {
            this.test = test;
            this.results = results;
            Map methodMetaData = (Map)BenchmarkReport.this.testMetaData.get(test.getClass().toString());
            this.metaData = (MetaData)methodMetaData.get(test.getName());
        }

        Element toElement(Document doc) {
            Element benchmark = doc.createElement("benchmark");
            benchmark.setAttribute("class", this.test.getClass().getName());
            benchmark.setAttribute("name", this.metaData.getTestName());
            benchmark.setAttribute("description", this.metaData.getTestDescription());
            String sourceCode = this.metaData.getSourceCode();
            if (sourceCode != null) {
                Element sourceCodeElement = doc.createElement("source_code");
                sourceCodeElement.appendChild(doc.createTextNode(sourceCode));
                benchmark.appendChild(sourceCodeElement);
            }
            for (BenchmarkResults result : this.results) {
                benchmark.appendChild(this.toElement(doc, result));
            }
            return benchmark;
        }

        private Element toElement(Document doc, BenchmarkResults result) {
            Element resultElement = doc.createElement("result");
            resultElement.setAttribute("host", result.getHost());
            resultElement.setAttribute("agent", result.getAgent());
            Throwable exception = result.getException();
            if (exception != null) {
                Element exceptionElement = doc.createElement("exception");
                exceptionElement.appendChild(doc.createTextNode(exception.toString()));
                resultElement.appendChild(exceptionElement);
            }
            List<Trial> trials = result.getTrials();
            for (Trial trial : trials) {
                Element trialElement = this.toElement(doc, trial);
                resultElement.appendChild(trialElement);
            }
            return resultElement;
        }

        private Element toElement(Document doc, Trial trial) {
            Element trialElement = doc.createElement("trial");
            Map<String, String> variables = trial.getVariables();
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                Element variableElement = doc.createElement("variable");
                variableElement.setAttribute("name", name.toString());
                variableElement.setAttribute("value", value.toString());
                trialElement.appendChild(variableElement);
            }
            trialElement.setAttribute("timing", String.valueOf(trial.getRunTimeMillis()));
            return trialElement;
        }
    }

    private static class Parser {
        private Map<JClassType, String> classSources = new HashMap<JClassType, String>();

        private Parser() {
        }

        public String getMethod(TreeLogger logger, JMethod method) {
            String source;
            JClassType clazz = method.getEnclosingType();
            if (!this.classSources.containsKey(clazz)) {
                char[] sourceContents = null;
                File sourceFile = BenchmarkReport.findSourceFile(clazz);
                if (sourceFile != null) {
                    sourceContents = Util.readFileAsChars((File)sourceFile);
                    this.classSources.put(clazz, new String(sourceContents));
                }
                if (sourceContents == null) {
                    this.classSources.put(clazz, null);
                    String msg = "An unknown I/O exception occured while trying to read " + (sourceFile == null ? "class " + clazz + " (not found)" : sourceFile.getAbsolutePath());
                    logger.log(TreeLogger.WARN, msg, null);
                } else {
                    this.classSources.put(clazz, new String(sourceContents));
                    String msg = "BenchmarkReport read the contents of " + sourceFile.getAbsolutePath();
                    TreeLogger branch = logger.branch(TreeLogger.DEBUG, msg, null);
                    if (logger.isLoggable(TreeLogger.SPAM)) {
                        branch.log(TreeLogger.SPAM, new String(sourceContents), null);
                    }
                }
            }
            if ((source = this.classSources.get(clazz)) == null) {
                return source;
            }
            return null;
        }
    }

    private class ReportXml {
        private Date date = new Date();
        private String version = "unknown";

        private ReportXml() {
        }

        Element toElement(Document doc) {
            Element report = doc.createElement("gwt_benchmark_report");
            String dateString = DateFormat.getDateTimeInstance().format(this.date);
            report.setAttribute("date", dateString);
            report.setAttribute("gwt_version", this.version);
            for (Map.Entry entry : BenchmarkReport.this.testResults.entrySet()) {
                TestCase test = (TestCase)entry.getKey();
                List results = (List)entry.getValue();
                BenchmarkXml xml = new BenchmarkXml(test, results);
                Element categoryElement = this.getCategoryElement(doc, report);
                categoryElement.appendChild(xml.toElement(doc));
            }
            return report;
        }

        private Element getCategoryElement(Document doc, Element report) {
            Element categoryElement = doc.createElement("category");
            categoryElement.setAttribute("name", "");
            categoryElement.setAttribute("description", "");
            report.appendChild(categoryElement);
            return categoryElement;
        }
    }
}

