/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.editors;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.reviews.core.ReviewSubTask;
import org.eclipse.mylyn.reviews.core.ReviewsUtil;
import org.eclipse.mylyn.reviews.ui.Images;
import org.eclipse.mylyn.reviews.ui.editors.Messages;
import org.eclipse.mylyn.reviews.ui.editors.TableLabelProvider;
import org.eclipse.mylyn.reviews.ui.wizard.CreateReviewWizard;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.core.data.ITaskDataManager;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ReviewSummaryTaskEditorPart
extends AbstractTaskEditorPart {
    public static final String ID_PART_REVIEWSUMMARY = "org.eclipse.mylyn.reviews.ui.editors.parts.reviewsummary";

    public ReviewSummaryTaskEditorPart() {
        this.setPartName(Messages.ReviewSummaryTaskEditorPart_Partname);
    }

    public void createControl(final Composite parent, FormToolkit toolkit) {
        Section summarySection = this.createSection(parent, toolkit, 322);
        summarySection.setLayout((Layout)new FillLayout(256));
        summarySection.setLayoutData((Object)new GridData(4, 4, true, true));
        summarySection.setText(Messages.ReviewSummaryTaskEditorPart_Partname);
        Composite reviewResultsComposite = toolkit.createComposite((Composite)summarySection);
        reviewResultsComposite.setLayout((Layout)new GridLayout(1, false));
        TableViewer reviewResults = this.createResultsTableViewer(reviewResultsComposite);
        reviewResults.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Button wizardButton = toolkit.createButton(reviewResultsComposite, "New Review", 8);
        wizardButton.setImage(TasksUiImages.TASK_NEW_SUB.createImage());
        wizardButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateReviewWizard wizard = new CreateReviewWizard(ReviewSummaryTaskEditorPart.this.getModel());
                WizardDialog dialog = new WizardDialog(parent.getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        summarySection.setClient((Control)reviewResultsComposite);
    }

    private TableViewerColumn createColumn(TableViewer parent, String columnTitle) {
        TableViewerColumn column = new TableViewerColumn(parent, 16384);
        column.getColumn().setText(columnTitle);
        column.getColumn().setWidth(100);
        column.getColumn().setResizable(true);
        return column;
    }

    private TableViewer createResultsTableViewer(Composite reviewResultsComposite) {
        TableViewer reviewResults = new TableViewer(reviewResultsComposite);
        reviewResults.getTable().setHeaderVisible(true);
        this.createColumn(reviewResults, Messages.ReviewSummaryTaskEditorPart_Header_ReviewId);
        this.createColumn(reviewResults, Messages.ReviewSummaryTaskEditorPart_Header_Scope);
        this.createColumn(reviewResults, Messages.ReviewSummaryTaskEditorPart_Header_Author);
        this.createColumn(reviewResults, Messages.ReviewSummaryTaskEditorPart_Header_Reviewer);
        this.createColumn(reviewResults, Messages.ReviewSummaryTaskEditorPart_Header_Result);
        this.createColumn(reviewResults, Messages.ReviewSummaryTaskEditorPart_Header_Comment);
        reviewResults.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ITaskContainer) {
                    ITaskContainer taskContainer = (ITaskContainer)inputElement;
                    List reviewSubTasks = ReviewsUtil.getReviewSubTasksFor((ITaskContainer)taskContainer, (ITaskDataManager)TasksUi.getTaskDataManager(), (IRepositoryModel)TasksUi.getRepositoryModel(), (IProgressMonitor)new NullProgressMonitor());
                    return reviewSubTasks.toArray(new ReviewSubTask[reviewSubTasks.size()]);
                }
                return null;
            }
        });
        reviewResults.setLabelProvider((IBaseLabelProvider)new TableLabelProvider(){
            private static final int COLUMN_ID = 0;
            private static final int COLUMN_PATCHFILE = 1;
            private static final int COLUMN_AUTHOR = 2;
            private static final int COLUMN_REVIEWER = 3;
            private static final int COLUMN_RESULT = 4;
            private static final int COLUMN_COMMENT = 5;

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 4) {
                    ReviewSubTask subtask = (ReviewSubTask)element;
                    switch (subtask.getResult()) {
                        case FAILED: {
                            return Images.REVIEW_RESULT_FAILED.createImage();
                        }
                        case WARNING: {
                            return Images.REVIEW_RESULT_WARNING.createImage();
                        }
                        case PASSED: {
                            return Images.REVIEW_RESULT_PASSED.createImage();
                        }
                        case NONE: {
                            return Images.REVIEW_RESULT_NONE.createImage();
                        }
                    }
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                ReviewSubTask subtask = (ReviewSubTask)element;
                switch (columnIndex) {
                    case 0: {
                        return subtask.getTask().getTaskId();
                    }
                    case 1: {
                        return subtask.getPatchDescription();
                    }
                    case 2: {
                        return subtask.getAuthor();
                    }
                    case 3: {
                        return subtask.getReviewer();
                    }
                    case 4: {
                        return subtask.getResult().getName();
                    }
                    case 5: {
                        return subtask.getComment();
                    }
                }
                return null;
            }
        });
        reviewResults.setInput((Object)this.getModel().getTask());
        reviewResults.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    ITask task = ((ReviewSubTask)((IStructuredSelection)event.getSelection()).getFirstElement()).getTask();
                    TasksUiUtil.openTask((ITask)task);
                }
            }
        });
        return reviewResults;
    }
}

