/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.reviews.core.model.review.ScopeItem;
import org.eclipse.mylyn.reviews.ui.PatchCreator;
import org.eclipse.mylyn.reviews.ui.wizard.CreateReviewWizard;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;

public class CreateReviewAction
extends Action
implements IActionDelegate {
    private ITaskAttachment attachment;

    public void run(IAction action) {
        if (this.attachment != null) {
            try {
                ITaskDataWorkingCopy taskDataState = TasksUiPlugin.getTaskDataManager().getWorkingCopy(this.attachment.getTask());
                TaskDataModel model = new TaskDataModel(this.attachment.getTaskRepository(), this.attachment.getTask(), taskDataState);
                CreateReviewWizard wizard = new CreateReviewWizard(model, (ScopeItem)new PatchCreator(this.attachment.getTaskAttribute()).create());
                WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        action.setEnabled(false);
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            this.attachment = (ITaskAttachment)structuredSelection.getFirstElement();
            if (this.attachment.isPatch()) {
                action.setEnabled(true);
            }
        }
    }
}

