/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.ui.naming.typeconfiguration;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.repository.data.ui.naming.IRequirementNamingPreferenceManager;
import org.polarsys.reqcycle.repository.data.ui.naming.strategy.IStrategy;
import org.polarsys.reqcycle.repository.data.ui.naming.strategy.IStrategyWithID;
import org.polarsys.reqcycle.repository.data.ui.naming.typeconfiguration.TypeConfiguration;
import org.polarsys.reqcycle.repository.data.ui.naming.typeconfiguration.TypeConfigurationTypeCouple;
import org.polarsys.reqcycle.repository.data.ui.naming.variable.IVariable;
import org.polarsys.reqcycle.repository.data.ui.naming.variable.IVariableWithID;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class TypeConfigurationDialog
extends Dialog {
    @Inject
    IRequirementNamingPreferenceManager namingPreferenceManager;
    private Text textPattern;
    private ComboViewer comboViewerStrategy;
    private Combo comboStrategy;
    private ComboViewer comboViewerType;
    private Combo comboType;
    private ListViewer listViewer;
    private Button btnAdd;
    private Button btnRemove;
    private Spinner spinnerStep;
    private Spinner spinnerDigits;
    TypeConfigurationTypeCouple couple;
    IDataModel datamodel;

    public TypeConfigurationDialog(Shell parentShell, IDataModel dm) {
        super(parentShell);
        this.setShellStyle(1200);
        ZigguratInject.inject((Object[])new Object[]{this});
        this.datamodel = dm;
    }

    public TypeConfigurationDialog(Shell parentShell, IDataModel dm, TypeConfigurationTypeCouple conftype) {
        this(parentShell, dm);
        this.couple = conftype;
    }

    private void loadConfiguration() {
        TypeConfiguration conf = this.couple.getConfiguration();
        String pattern = conf.getPattern();
        this.textPattern.setText(pattern);
        this.comboViewerStrategy.setSelection((ISelection)new StructuredSelection((Object)conf.getStrategy()));
        this.spinnerStep.setSelection(conf.getStep());
        this.spinnerDigits.setSelection(conf.getDigits());
        this.comboViewerType.setSelection((ISelection)new StructuredSelection((Object)this.couple.getType()));
        this.comboType.setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite_6 = new Composite(container, 0);
        composite_6.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite_6.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(composite_6, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblType = new Label(composite, 0);
        lblType.setText("Type");
        this.comboViewerType = new ComboViewer(composite, 8);
        this.comboType = this.comboViewerType.getCombo();
        this.comboType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite composite_1 = new Composite(composite_6, 0);
        composite_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        composite_1.setLayout((Layout)new GridLayout(2, false));
        Label lblVariables = new Label(composite_1, 0);
        lblVariables.setLayoutData((Object)new GridData(16384, 1024, false, false, 1, 1));
        lblVariables.setText("Variables");
        new Label(composite_1, 0);
        this.listViewer = new ListViewer(composite_1, 2560);
        org.eclipse.swt.widgets.List list = this.listViewer.getList();
        list.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite composite_4 = new Composite(composite_1, 0);
        composite_4.setLayout((Layout)new GridLayout(1, false));
        this.btnAdd = new Button(composite_4, 0);
        this.btnAdd.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnAdd.setText("Insert");
        this.btnRemove = new Button(composite_4, 0);
        this.btnRemove.setText("Remove");
        Composite composite_7 = new Composite(composite_6, 0);
        composite_7.setLayout((Layout)new GridLayout(2, false));
        composite_7.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblPattern = new Label(composite_7, 0);
        lblPattern.setText("Pattern");
        this.textPattern = new Text(composite_7, 2048);
        this.textPattern.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        Group grpIndexVariableOptions = new Group(composite_7, 0);
        grpIndexVariableOptions.setLayout((Layout)new GridLayout(2, false));
        grpIndexVariableOptions.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        grpIndexVariableOptions.setText("Index variable options");
        Label lblStrategy = new Label((Composite)grpIndexVariableOptions, 0);
        lblStrategy.setText("Strategy");
        this.comboViewerStrategy = new ComboViewer((Composite)grpIndexVariableOptions, 8);
        this.comboStrategy = this.comboViewerStrategy.getCombo();
        this.comboStrategy.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        Label lblStep = new Label((Composite)grpIndexVariableOptions, 0);
        lblStep.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblStep.setSize(23, 15);
        lblStep.setText("Step");
        this.spinnerStep = new Spinner((Composite)grpIndexVariableOptions, 2048);
        this.spinnerStep.setSize(71, 22);
        this.spinnerStep.setMaximum(1000000);
        this.spinnerStep.setSelection(10);
        this.spinnerStep.setPageIncrement(1);
        Label lblDigits = new Label((Composite)grpIndexVariableOptions, 0);
        lblDigits.setSize(30, 15);
        lblDigits.setText("Digits");
        this.spinnerDigits = new Spinner((Composite)grpIndexVariableOptions, 2048);
        this.spinnerDigits.setSize(47, 22);
        this.spinnerDigits.setMinimum(1);
        this.spinnerDigits.setSelection(5);
        this.setComboStrategyProviders();
        this.setComboTypeProviders();
        this.setListProviders();
        this.hookListeners();
        if (this.couple != null) {
            this.loadConfiguration();
        }
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void setComboStrategyProviders() {
        this.comboViewerStrategy.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IStrategy) {
                    return ((IStrategy)element).getText();
                }
                return super.getText(element);
            }
        });
        this.comboViewerStrategy.setContentProvider((IContentProvider)new ArrayContentProvider());
        List<IStrategyWithID> list = this.namingPreferenceManager.getAllRegisteredStrategies();
        if (list == null || list.isEmpty()) {
            return;
        }
        this.comboViewerStrategy.setInput(list);
        this.comboViewerStrategy.setSelection((ISelection)new StructuredSelection((Object)list.get(0)));
    }

    private void setComboTypeProviders() {
        this.comboViewerType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IType) {
                    return ((IType)element).getName();
                }
                return super.getText(element);
            }
        });
        this.comboViewerType.setContentProvider((IContentProvider)new ArrayContentProvider());
        ArrayList<IType> list = new ArrayList<IType>(this.namingPreferenceManager.getUnSetTypes(this.datamodel));
        if (this.couple != null) {
            list.add(this.couple.getType());
        }
        if (list.isEmpty()) {
            return;
        }
        this.comboViewerType.setInput(list);
        this.comboViewerType.setSelection((ISelection)new StructuredSelection((Object)list.get(0)));
    }

    private void setListProviders() {
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return ((IVariable)element).getName();
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TypeConfigurationDialog.this.insertVariable();
            }
        });
        ArrayList<IVariableWithID> list = new ArrayList<IVariableWithID>(this.namingPreferenceManager.getAllRegisteredVariables().values());
        if (list == null || list.isEmpty()) {
            return;
        }
        this.listViewer.setInput(list);
    }

    private void hookListeners() {
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeConfigurationDialog.this.insertVariable();
            }
        });
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
    }

    private IVariableWithID getSelectedVariable() {
        return (IVariableWithID)((IStructuredSelection)this.listViewer.getSelection()).getFirstElement();
    }

    private IStrategyWithID getSelectedStrategy() {
        return (IStrategyWithID)((IStructuredSelection)this.comboViewerStrategy.getSelection()).getFirstElement();
    }

    private IType getSelectedType() {
        return (IType)((IStructuredSelection)this.comboViewerType.getSelection()).getFirstElement();
    }

    public TypeConfigurationTypeCouple getCouple() {
        return this.couple;
    }

    public void saveAll() {
        TypeConfiguration config = TypeConfiguration.create().setPattern(this.textPattern.getText()).setStrategy(this.getSelectedStrategy()).setStep(this.spinnerStep.getSelection()).setDigits(this.spinnerDigits.getSelection());
        this.couple = new TypeConfigurationTypeCouple(this.getSelectedType(), config);
    }

    protected void okPressed() {
        if (!this.valid()) {
            return;
        }
        this.saveAll();
        super.okPressed();
    }

    private boolean valid() {
        if (this.textPattern.getText() == "") {
            return false;
        }
        if (this.getSelectedType() == null) {
            return false;
        }
        return this.getSelectedStrategy() != null;
    }

    protected Point getInitialSize() {
        Monitor monitor = this.getShell().getMonitor();
        int ratio = 4;
        return new Point(monitor.getBounds().width / ratio * 2, monitor.getBounds().height / ratio * 2);
    }

    protected Point getInitialLocation(Point initialSize) {
        Monitor monitor = this.getShell().getMonitor();
        int ratio = 4;
        return new Point(monitor.getBounds().width / ratio, monitor.getBounds().height / ratio);
    }

    protected void insertVariable() {
        IVariableWithID var = this.getSelectedVariable();
        if (var != null) {
            this.textPattern.insert("{" + var.getName() + "}");
        }
    }
}

