/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.impact.ui.dialogs;

import java.util.Set;
import javax.inject.Inject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.polarsys.reqcycle.core.ui.dialogs.ValidatingTitleAreaDialog;
import org.polarsys.reqcycle.repository.connector.ConnectorDescriptor;
import org.polarsys.reqcycle.repository.connector.IConnectorManager;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.util.DataUtil;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class SelectModelDialog
extends ValidatingTitleAreaDialog
implements IDoubleClickListener {
    @Inject
    IDataManager requirementSourceManager;
    @Inject
    IConnectorManager repositoryConnectorManager;
    private TreeViewer viewer;
    private RequirementSource sourceSelected;

    public SelectModelDialog(Shell parentShell) {
        super(parentShell);
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.validateInput();
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Select version");
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayout((Layout)new GridLayout(1, false));
        area.setLayoutData((Object)new GridData(1808));
        this.viewer = new TreeViewer(area, 768);
        Tree tree = this.viewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.viewer.setContentProvider((IContentProvider)new RSContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RSLabelProvider());
        this.viewer.setInput(this.requirementSourceManager.getRepositoryMap().keySet());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (((IStructuredSelection)event.getSelection()).getFirstElement() instanceof RequirementSource) {
                    SelectModelDialog.this.sourceSelected = (RequirementSource)((IStructuredSelection)event.getSelection()).getFirstElement();
                    SelectModelDialog.this.validateInput();
                }
            }
        });
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
        return area;
    }

    public ValidatingTitleAreaDialog.IValidator getInputValidator() {
        return new ValidatingTitleAreaDialog.IValidator(){

            public String isValid() {
                if (SelectModelDialog.this.sourceSelected == null) {
                    return "A Requirement Source must be selected";
                }
                return null;
            }
        };
    }

    public RequirementSource getRequirementSource() {
        return this.sourceSelected;
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.sourceSelected != null) {
            this.close();
        }
    }

    public class RSContentProvider
    implements ITreeContentProvider,
    IStructuredContentProvider {
        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof Set) {
                return ((Set)parent).toArray();
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getChildren(Object parent) {
            Set repositories = SelectModelDialog.this.requirementSourceManager.getRequirementSources((String)parent);
            return repositories.toArray();
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof String) {
                return !SelectModelDialog.this.requirementSourceManager.getRequirementSources((String)parent).isEmpty();
            }
            return false;
        }
    }

    public class RSLabelProvider
    extends LabelProvider {
        public String getText(Object obj) {
            if (obj instanceof String) {
                ConnectorDescriptor connectorDescriptor = SelectModelDialog.this.repositoryConnectorManager.get((String)obj);
                if (connectorDescriptor != null) {
                    return connectorDescriptor.getName();
                }
                return "";
            }
            if (obj instanceof RequirementSource) {
                return DataUtil.getLabel((Object)obj);
            }
            return obj.toString();
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

