/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.impact.ui.dialogs;

import javax.inject.Inject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.reqcycle.core.ui.dialogs.ValidatingTitleAreaDialog;
import org.polarsys.reqcycle.impact.ui.dialogs.SelectModelDialog;
import org.polarsys.reqcycle.impact.ui.dialogs.SelectVersionDialog;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class ImpactAnalysisInputSelectorDialog
extends ValidatingTitleAreaDialog {
    @Inject
    IDataModelManager dataModelManager;
    private RequirementSource requirementSource;
    private RequirementSource requirementSourceFrom;
    private RequirementSource requirementSourceTo;
    private String initialVersion;
    private String finalVersion;
    private Label lblModelSelected;
    private Label lblVersionSelectedFrom;
    private Label lblVersionSelectedTo;
    private Button btnVersionFromButton;
    private Button btnVersionToButton;

    public ImpactAnalysisInputSelectorDialog(Shell parentShell, RequirementSource requirementSource) {
        super(parentShell);
        this.setShellStyle(1216);
        ZigguratInject.inject((Object[])new Object[]{this});
        this.requirementSource = requirementSource;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Select inputs for impact analysis");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblModel = new Label(container, 0);
        lblModel.setText("Select model for impact analysis :");
        this.lblModelSelected = new Label(container, 2048);
        this.lblModelSelected.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.lblModelSelected.setEnabled(false);
        Button btnModelButton = new Button(container, 0);
        btnModelButton.setToolTipText("Select model");
        btnModelButton.setText("...");
        btnModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectModelDialog dialog = new SelectModelDialog(Display.getDefault().getActiveShell());
                if (dialog.open() == 0) {
                    ImpactAnalysisInputSelectorDialog.this.requirementSource = dialog.getRequirementSource();
                    ImpactAnalysisInputSelectorDialog.this.lblModelSelected.setText(ImpactAnalysisInputSelectorDialog.this.requirementSource.getName());
                    ImpactAnalysisInputSelectorDialog.this.btnVersionFromButton.setEnabled(true);
                    ImpactAnalysisInputSelectorDialog.this.btnVersionToButton.setEnabled(true);
                    if (ImpactAnalysisInputSelectorDialog.this.requirementSourceFrom != null) {
                        ImpactAnalysisInputSelectorDialog.this.requirementSourceFrom = null;
                        ImpactAnalysisInputSelectorDialog.this.lblVersionSelectedFrom.setText("");
                    }
                    if (ImpactAnalysisInputSelectorDialog.this.requirementSourceTo != null) {
                        ImpactAnalysisInputSelectorDialog.this.requirementSourceTo = null;
                        ImpactAnalysisInputSelectorDialog.this.lblVersionSelectedTo.setText("");
                    }
                    ImpactAnalysisInputSelectorDialog.this.validateInput();
                }
            }
        });
        Label lblVersionFrom = new Label(container, 0);
        lblVersionFrom.setText("Select initial version :");
        this.lblVersionSelectedFrom = new Label(container, 2048);
        this.lblVersionSelectedFrom.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.lblVersionSelectedFrom.setEnabled(false);
        this.btnVersionFromButton = new Button(container, 0);
        this.btnVersionFromButton.setToolTipText("Select initial version");
        this.btnVersionFromButton.setText("...");
        this.btnVersionFromButton.setEnabled(false);
        this.btnVersionFromButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectVersionDialog dialog;
                if (ImpactAnalysisInputSelectorDialog.this.requirementSource != null && (dialog = new SelectVersionDialog(Display.getDefault().getActiveShell(), ImpactAnalysisInputSelectorDialog.this.requirementSource)).open() == 0) {
                    ImpactAnalysisInputSelectorDialog.this.requirementSourceFrom = dialog.getRequirementSource();
                    ImpactAnalysisInputSelectorDialog.this.initialVersion = dialog.getRSVersion();
                    ImpactAnalysisInputSelectorDialog.this.lblVersionSelectedFrom.setText(ImpactAnalysisInputSelectorDialog.this.initialVersion);
                    ImpactAnalysisInputSelectorDialog.this.validateInput();
                }
            }
        });
        Label lblVersionTo = new Label(container, 0);
        lblVersionTo.setText("Select final version :");
        this.lblVersionSelectedTo = new Label(container, 2048);
        this.lblVersionSelectedTo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.lblVersionSelectedTo.setEnabled(false);
        this.btnVersionToButton = new Button(container, 0);
        this.btnVersionToButton.setToolTipText("Select final version");
        this.btnVersionToButton.setText("...");
        this.btnVersionToButton.setEnabled(false);
        this.btnVersionToButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectVersionDialog dialog;
                if (ImpactAnalysisInputSelectorDialog.this.requirementSource != null && (dialog = new SelectVersionDialog(Display.getDefault().getActiveShell(), ImpactAnalysisInputSelectorDialog.this.requirementSource)).open() == 0) {
                    ImpactAnalysisInputSelectorDialog.this.requirementSourceTo = dialog.getRequirementSource();
                    ImpactAnalysisInputSelectorDialog.this.finalVersion = dialog.getRSVersion();
                    ImpactAnalysisInputSelectorDialog.this.lblVersionSelectedTo.setText(ImpactAnalysisInputSelectorDialog.this.finalVersion);
                    ImpactAnalysisInputSelectorDialog.this.validateInput();
                }
            }
        });
        if (this.requirementSource != null) {
            this.lblModelSelected.setText(this.requirementSource.getName());
            this.btnVersionFromButton.setEnabled(true);
            this.btnVersionToButton.setEnabled(true);
        }
        this.validateInput();
        return area;
    }

    public ValidatingTitleAreaDialog.IValidator getInputValidator() {
        return new ValidatingTitleAreaDialog.IValidator(){

            public String isValid() {
                if (ImpactAnalysisInputSelectorDialog.this.requirementSource == null) {
                    return "A Data Source must be selected";
                }
                if (ImpactAnalysisInputSelectorDialog.this.requirementSourceFrom == null) {
                    return "An initial version must be selected";
                }
                if (ImpactAnalysisInputSelectorDialog.this.requirementSourceTo == null) {
                    return "An final version must be selected";
                }
                return null;
            }
        };
    }

    public RequirementSource getRequirementSource() {
        return this.requirementSource;
    }

    public RequirementSource getRequirementSourceFrom() {
        return this.requirementSourceFrom;
    }

    public RequirementSource getRequirementSourceTo() {
        return this.requirementSourceTo;
    }

    public String getInitialVersion() {
        return this.initialVersion;
    }

    public String getFinalVersion() {
        return this.finalVersion;
    }
}

