/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.ui.datepropseditor.internal.components;

import java.util.Calendar;
import java.util.Comparator;
import java.util.TimeZone;
import java.util.TreeSet;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class CommonDatePropsEditor
extends Composite {
    private final Calendar calendarValue;
    private DateTime dateCalendar;
    private DateTime dateTime;
    private ComboViewer comboViewer;

    CommonDatePropsEditor(String attributeName, Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
        this.calendarValue = Calendar.getInstance();
        Label lblName = new Label((Composite)this, 0);
        lblName.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        lblName.setText(attributeName);
        Composite calendarAndTimeComposite = new Composite((Composite)this, 0);
        calendarAndTimeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        calendarAndTimeComposite.setLayout((Layout)new FillLayout(256));
        this.initDateCalendar(calendarAndTimeComposite);
        this.initDateTime(calendarAndTimeComposite);
        this.initComboTimezones(parent);
    }

    Calendar getCalendarValue() {
        return this.calendarValue;
    }

    private void initDateCalendar(Composite parent) {
        this.dateCalendar = new DateTime(parent, 2052);
        this.dateCalendar.setToolTipText("Calendar");
        this.dateCalendar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonDatePropsEditor.this.calendarValue.set(1, CommonDatePropsEditor.this.dateCalendar.getYear());
                CommonDatePropsEditor.this.calendarValue.set(2, CommonDatePropsEditor.this.dateCalendar.getMonth());
                CommonDatePropsEditor.this.calendarValue.set(5, CommonDatePropsEditor.this.dateCalendar.getDay());
            }
        });
    }

    private void initDateTime(Composite parent) {
        this.dateTime = new DateTime(parent, 2176);
        this.dateTime.setToolTipText("Time");
        this.dateTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonDatePropsEditor.this.calendarValue.set(11, CommonDatePropsEditor.this.dateTime.getHours());
                CommonDatePropsEditor.this.calendarValue.set(12, CommonDatePropsEditor.this.dateTime.getMinutes());
                CommonDatePropsEditor.this.calendarValue.set(13, CommonDatePropsEditor.this.dateTime.getSeconds());
            }
        });
    }

    private void initComboTimezones(Composite parent) {
        this.comboViewer = new ComboViewer((Composite)this, 8);
        Combo comboTimezones = this.comboViewer.getCombo();
        comboTimezones.setToolTipText("Timezone");
        comboTimezones.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TimeZone) {
                    return ((TimeZone)element).getID();
                }
                return super.getText(element);
            }
        });
        this.comboViewer.setInput((Object)CommonDatePropsEditor.getAvailableTimezones());
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection;
                if (CommonDatePropsEditor.this.comboViewer.getSelection() instanceof IStructuredSelection && !(selection = (IStructuredSelection)CommonDatePropsEditor.this.comboViewer.getSelection()).isEmpty()) {
                    TimeZone seletedTimezone = (TimeZone)selection.getFirstElement();
                    CommonDatePropsEditor.this.calendarValue.setTimeZone(seletedTimezone);
                }
            }
        });
    }

    private static TimeZone[] getAvailableTimezones() {
        TreeSet<TimeZone> availableTimezones = new TreeSet<TimeZone>(new TimeZoneComparator());
        String[] stringArray = TimeZone.getAvailableIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            availableTimezones.add(TimeZone.getTimeZone(id));
            ++n2;
        }
        return availableTimezones.toArray(new TimeZone[availableTimezones.size()]);
    }

    private static class TimeZoneComparator
    implements Comparator<TimeZone> {
        private TimeZoneComparator() {
        }

        @Override
        public int compare(TimeZone tz1, TimeZone tz2) {
            return tz1.getID().compareTo(tz2.getID());
        }
    }
}

