/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.styling.manager.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.reqcycle.styling.manager.IStylingManager;
import org.polarsys.reqcycle.styling.model.Styling.CaseStyle;
import org.polarsys.reqcycle.styling.model.Styling.Styling;
import org.polarsys.reqcycle.styling.model.Styling.StylingFactory;
import org.polarsys.reqcycle.styling.model.Styling.StylingModel;
import org.polarsys.reqcycle.styling.model.Styling.StylingPredicate;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;

@Singleton
public class StylingManager
implements IStylingManager {
    private static String PREF_ID = "org.polarsys.reqcycle.styling.manager.styling";
    private static String PREF_ID_PREFERRED = "org.polarsys.reqcycle.styling.manager.styling.preferred";
    @Inject
    IConfigurationManager confManager;
    private String preferredStylingModel;
    private Styling currentModel;

    @PostConstruct
    void postConstruct() {
        this.reload();
    }

    @Override
    public Styling getStyling() {
        return this.currentModel;
    }

    @Override
    public void setPreferredStylingModel(String stylingModel) {
        this.preferredStylingModel = stylingModel;
    }

    @Override
    public String getPreferredStyleModel() {
        return this.preferredStylingModel;
    }

    @Override
    public void suppressUselessPredicates() {
        CaseStyle caseStyle = null;
        ArrayList toDelete = Lists.newArrayList();
        for (StylingModel model : this.currentModel.getModels()) {
            for (CaseStyle style : model.getStyles()) {
                StylingPredicate stylingPredicate;
                if (!(style instanceof StylingPredicate) || (stylingPredicate = (StylingPredicate)style) == null || stylingPredicate.getPredicate() != null) continue;
                caseStyle = style;
                model.getStyles();
                toDelete.add(caseStyle);
            }
        }
        for (CaseStyle c : toDelete) {
            EcoreUtil.delete((EObject)c, (boolean)true);
        }
        this.save();
    }

    @Override
    public void save() {
        try {
            this.confManager.saveConfiguration(Collections.singleton(this.currentModel), null, null, PREF_ID, null, null);
            HashMap conf = Maps.newHashMap();
            conf.put(PREF_ID_PREFERRED, this.preferredStylingModel);
            this.confManager.saveSimpleConfiguration((Map)conf, null, null, PREF_ID_PREFERRED);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reload() {
        EObject first;
        Collection conf = this.confManager.getConfiguration(null, null, PREF_ID, null, null, true);
        this.currentModel = conf != null && conf.size() != 0 ? ((first = (EObject)conf.iterator().next()) instanceof Styling ? (Styling)first : StylingFactory.eINSTANCE.createStyling()) : StylingFactory.eINSTANCE.createStyling();
        Map map = this.confManager.getSimpleConfiguration(null, null, PREF_ID_PREFERRED, false);
        if (map != null) {
            this.preferredStylingModel = (String)map.get(PREF_ID_PREFERRED);
        }
    }
}

