/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.emf.ReqCycleTraceability.impl;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.polarsys.reqcycle.traceability.emf.Activator;
import org.polarsys.reqcycle.traceability.emf.ReqCycleTraceability.ELink;
import org.polarsys.reqcycle.traceability.emf.ReqCycleTraceability.EReachable;
import org.polarsys.reqcycle.traceability.emf.ReqCycleTraceability.IRequestManager;
import org.polarsys.reqcycle.traceability.emf.ReqCycleTraceability.ReqCycleTraceabilityFactory;
import org.polarsys.reqcycle.traceability.emf.ReqCycleTraceability.ReqCycleTraceabilityPackage;
import org.polarsys.reqcycle.traceability.emf.ReqCycleTraceability.impl.ElementImpl;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.engine.Request;
import org.polarsys.reqcycle.traceability.exceptions.EngineException;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.types.IType;
import org.polarsys.reqcycle.types.ITypesManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.IReachableHandler;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class EReachableImpl
extends ElementImpl
implements EReachable {
    @Inject
    ITraceabilityEngine engine;
    @Inject
    IRequestManager requestManager;
    private ITypesManager typeManager = (ITypesManager)ZigguratInject.make(ITypesManager.class);
    public static final String copyright = "Copyright (c) 2013 AtoS\r\nAll rights reserved. This program and the accompanying materials\r\nare made available under the terms of the Eclipse Public License v1.0\r\nwhich accompanies this distribution, and is available at\r\nhttp://www.eclipse.org/legal/epl-v10.html *\r\nContributors:\r\n Abdellah EL AYADI (AtoS) - initial API and implementation and/or initial documentation";
    protected EList<ELink> downwards;
    protected EList<String> types;
    protected EList<ELink> upwards;

    protected EReachableImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ReqCycleTraceabilityPackage.Literals.EREACHABLE;
    }

    @Override
    public EList<ELink> getDownwards() {
        if (this.downwards == null) {
            this.downwards = new EObjectResolvingEList(ELink.class, (InternalEObject)this, 2);
            try {
                this.initDownwards();
            }
            catch (EngineException e) {
                Activator.log(4, "Error while retrieving downwards", e);
            }
        }
        return this.downwards;
    }

    protected void initDownwards() throws EngineException {
        if (this.downwards == null) {
            this.downwards = new EObjectResolvingEList(ELink.class, (InternalEObject)this, 2);
        }
        this.downwards.clear();
        Iterator traceability = this.engine.getTraceability(new Request[]{this.requestManager.getDownwardRequest(this)});
        while (traceability.hasNext()) {
            Pair pair = (Pair)traceability.next();
            Link link = (Link)pair.getFirst();
            Reachable reachable = (Reachable)pair.getSecond();
            URI reachableURI = reachable.getURI();
            EReachableImpl target = (EReachableImpl)this.eResource().getEObject(reachableURI.toString());
            ELink eLink = target.getUpward(link.getId().getURI());
            if (eLink == null) {
                eLink = ReqCycleTraceabilityFactory.eINSTANCE.createELink();
                eLink.setLabel(link.getLabel());
                eLink.setURI(link.getId().getURI().toString());
                eLink.getUpwards().add((Object)this);
                eLink.getDownwards().add((Object)target);
                if (eLink instanceof InternalEObject && this.eResource() instanceof Resource.Internal) {
                    ((InternalEObject)eLink).eSetResource((Resource.Internal)this.eResource(), null);
                }
            }
            this.downwards.add((Object)eLink);
        }
    }

    protected ELink getUpward(URI uri) {
        if (this.upwards != null && uri != null) {
            for (ELink eLink : this.upwards) {
                if (!uri.toString().equals(eLink.getURI())) continue;
                return eLink;
            }
        }
        return null;
    }

    protected ELink getDownward(URI uri) {
        if (this.downwards != null && uri != null) {
            for (ELink eLink : this.downwards) {
                if (!uri.equals(eLink.getURI())) continue;
                return eLink;
            }
        }
        return null;
    }

    @Override
    public EList<String> getTypes() {
        if (this.types == null) {
            this.initTypes();
        }
        return this.types;
    }

    protected void initTypes() {
        if (this.types == null) {
            this.types = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 3);
        }
        this.types.clear();
        Iterable reachableTypes = this.typeManager.getAllApplicableTypes((Reachable)this.getAdapter(Reachable.class));
        for (IType iType : reachableTypes) {
            this.types.add((Object)iType.getLabel());
        }
    }

    @Override
    public EList<ELink> getUpwards() {
        if (this.upwards == null) {
            this.upwards = new EObjectResolvingEList(ELink.class, (InternalEObject)this, 4);
            try {
                this.initUpwards();
            }
            catch (EngineException e) {
                Activator.log(4, "Error while retrieving upwards", e);
            }
        }
        return this.upwards;
    }

    @Override
    public EObject getEObject() {
        Reachable r = (Reachable)this.getAdapter(Reachable.class);
        try {
            IReachableHandler handler = this.reachableManager.getHandlerFromReachable(r);
            ReachableObject reachableObject = handler.getFromReachable(r);
            return (EObject)reachableObject.getAdapter(EObject.class);
        }
        catch (IReachableHandlerException e) {
            Activator.log(4, "Can't element EObject", e);
            return null;
        }
    }

    protected void initUpwards() throws EngineException {
        if (this.upwards == null) {
            this.upwards = new EObjectResolvingEList(ELink.class, (InternalEObject)this, 4);
        }
        this.upwards.clear();
        this.engine.getTraceability(new Request[]{this.requestManager.getUpwardRequest(this)});
        Iterator traceability = this.engine.getTraceability(new Request[]{this.requestManager.getUpwardRequest(this)});
        while (traceability.hasNext()) {
            Pair pair = (Pair)traceability.next();
            Link link = (Link)pair.getFirst();
            Reachable reachable = (Reachable)pair.getSecond();
            URI reachableURI = reachable.getURI();
            EReachableImpl target = (EReachableImpl)this.eResource().getEObject(reachableURI.toString());
            ELink eLink = target.getDownward(link.getId().getURI());
            if (eLink == null) {
                eLink = ReqCycleTraceabilityFactory.eINSTANCE.createELink();
                eLink.setURI(link.getId().toString());
                eLink.setLabel(link.getLabel());
                eLink.getDownwards().add((Object)this);
                eLink.getUpwards().add((Object)target);
                if (eLink instanceof InternalEObject && this.eResource() instanceof Resource.Internal) {
                    ((InternalEObject)eLink).eSetResource((Resource.Internal)this.eResource(), null);
                }
            }
            this.upwards.add((Object)eLink);
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getDownwards();
            }
            case 3: {
                return this.getTypes();
            }
            case 4: {
                return this.getUpwards();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.downwards != null && !this.downwards.isEmpty();
            }
            case 3: {
                return this.types != null && !this.types.isEmpty();
            }
            case 4: {
                return this.upwards != null && !this.upwards.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                return this.getEObject();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (types: ");
        result.append(this.types);
        result.append(')');
        return result.toString();
    }

    @Override
    public Object getAdapter(Class type) {
        if (type.equals(Reachable.class)) {
            String uri = this.getURI();
            try {
                Reachable sourceR = this.creator.getReachable(new URI(uri));
                return sourceR;
            }
            catch (URISyntaxException e) {
                Activator.log(4, "Can't Adapt element", e);
            }
        }
        return null;
    }
}

