/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Relation;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Type;
import org.polarsys.reqcycle.traceability.types.impl.TraceTypesManager;
import org.polarsys.reqcycle.types.ITypesManager;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class RelationUtils {
    static ITypesManager manager = (ITypesManager)ZigguratInject.make(ITypesManager.class);
    static TraceTypesManager tManager = (TraceTypesManager)ZigguratInject.make(TraceTypesManager.class);

    private static Type getTypeTarget(Relation r, ITraceabilityEngine.DIRECTION direction) {
        if (direction == ITraceabilityEngine.DIRECTION.DOWNWARD) {
            return r.getDownstreamType();
        }
        return r.getUpstreamType();
    }

    private static List<Relation> getRelations(Type type, ITraceabilityEngine.DIRECTION direction, Configuration config) {
        if (direction == ITraceabilityEngine.DIRECTION.DOWNWARD) {
            return RelationUtils.filter(type.getOutgoings(), config);
        }
        return RelationUtils.filter(type.getIncomings(), config);
    }

    private static List<Relation> filter(EList<Relation> incomings, final Configuration config) {
        return Lists.newArrayList((Iterable)Iterables.filter(incomings, (Predicate)new Predicate<Relation>(){

            public boolean apply(Relation r) {
                return r.eContainer() == config;
            }
        }));
    }

    public static Iterable<Relation> getAgregatingRelations(TType type, Configuration config, Reachable source, Reachable target, ITraceabilityEngine.DIRECTION direction) {
        HashSet<Relation> relations = new HashSet<Relation>();
        for (Relation r : config.getRelations()) {
            for (String s : r.getAgregatedTypes()) {
                Type sourceType;
                if (!type.equals((Object)tManager.getTType(s)) || (sourceType = RelationUtils.getSourceType(r, direction)) == null || !sourceType.getIType().is(source) || !RelationUtils.getTargetType(r, direction).getIType().is(target)) continue;
                relations.add(r);
            }
        }
        return relations;
    }

    private static Type getTargetType(Relation r, ITraceabilityEngine.DIRECTION direction) {
        if (direction == ITraceabilityEngine.DIRECTION.UPWARD) {
            return r.getUpstreamType();
        }
        return r.getDownstreamType();
    }

    private static Type getSourceType(Relation r, ITraceabilityEngine.DIRECTION direction) {
        if (direction == ITraceabilityEngine.DIRECTION.DOWNWARD) {
            return r.getUpstreamType();
        }
        return r.getDownstreamType();
    }

    public static Relation getRelation(String kind, Configuration conf) {
        for (Relation r : conf.getRelations()) {
            if (!r.getKind().equals(kind)) continue;
            return r;
        }
        return null;
    }

    public static Relation getMatchingRelation(Configuration config, TType kind, Reachable down, Reachable up) {
        for (Relation r : config.getRelations()) {
            boolean sourceAndTargetOk = kind.is(r.getTType());
            if (sourceAndTargetOk) {
                sourceAndTargetOk &= r.getDownstreamType().getIType().is(down);
            }
            if (sourceAndTargetOk) {
                sourceAndTargetOk &= r.getUpstreamType().getIType().is(up);
            }
            if (!sourceAndTargetOk) continue;
            return r;
        }
        return null;
    }
}

