/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.xcos.traceability.types;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.types.TTypeProvider;
import org.polarsys.reqcycle.xcos.traceability.types.XcosTType;

public class XcosTTypeProvider
implements TTypeProvider {
    private static TType[] TYPES = new XcosTType[]{new XcosTType("COVERS"), new XcosTType("IMPLEMENTS"), new XcosTType("TRACE")};
    private static Map<String, TType> MAP = Maps.uniqueIndex(Arrays.asList(TYPES), (Function)new Function<TType, String>(){

        public String apply(TType arg0) {
            return ((XcosTType)arg0).getMainLabel();
        }
    });

    public static TType get(String mainLabel) {
        TType result = MAP.get(mainLabel);
        if (result == null) {
            result = MAP.get("TRACE");
        }
        return result;
    }

    public Iterable<TType> getTTypes() {
        return Arrays.asList(TYPES);
    }
}

