/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.sesame.storage.repositoryholders;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.polarsys.reqcycle.traceability.storage.IStoragePathProvider;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.repositoryholders.AbstractSesameRepositoryHolder;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.savetriggers.ISaveTrigger;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.savetriggers.XMLSaveTrigger;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

@Singleton
public class SesameXMLRepositoryHolder
extends AbstractSesameRepositoryHolder<IProject> {
    private static final String DEFAULT_RDF_FILE = "./.traceability.rdf";
    @Inject
    IStoragePathProvider storagePathProvider;
    private String path;

    private static void loadDataFromStream(RepositoryConnection connection, InputStream stream) throws RepositoryException, IOException, RDFParseException {
        connection.begin();
        connection.add(stream, "", RDFFormat.RDFXML, new Resource[0]);
        connection.commit();
    }

    private static SailRepository createRepository() throws RepositoryException {
        MemoryStore store = new MemoryStore();
        store.setPersist(false);
        store.setSyncDelay(1000L);
        SailRepository repository = new SailRepository((Sail)store);
        repository.initialize();
        return repository;
    }

    public File getTargetFile(IProject project) throws RepositoryException {
        IFile ifile = this.getTargetIFile(project);
        IPath fullPath = ifile.getRawLocation().makeAbsolute();
        File file = fullPath.toFile();
        return file;
    }

    public IFile getTargetIFile(IProject project) throws RepositoryException {
        String newPath = this.storagePathProvider.getStoragePath();
        if (newPath == null || newPath.isEmpty()) {
            newPath = DEFAULT_RDF_FILE;
        }
        if (this.path == null) {
            this.path = newPath;
        } else if (!newPath.equals(this.path)) {
            this.path = newPath;
        }
        if (!this.path.endsWith(".rdf")) {
            this.path = String.valueOf(this.path) + ".rdf";
        }
        IFile ifile = project.getFile(this.path);
        return ifile;
    }

    @Override
    protected Repository initRepository(IProject project) throws IOException, OpenRDFException {
        SailRepository repository = SesameXMLRepositoryHolder.createRepository();
        File file = this.getTargetFile(project);
        if (file.exists()) {
            SailRepositoryConnection connection = repository.getConnection();
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
            try {
                SesameXMLRepositoryHolder.loadDataFromStream((RepositoryConnection)connection, stream);
            }
            finally {
                stream.close();
                connection.close();
            }
        }
        return repository;
    }

    @Override
    public RepositoryConnection getConnection(InputStream inputStream) throws RepositoryException, ExecutionException, RDFParseException, IOException {
        SailRepository repository = SesameXMLRepositoryHolder.createRepository();
        RepositoryConnection connection = repository.getConnection();
        SesameXMLRepositoryHolder.loadDataFromStream(connection, inputStream);
        return connection;
    }

    @Override
    public ISaveTrigger getSaveTrigger(IProject project) throws RepositoryException {
        XMLSaveTrigger trigger = new XMLSaveTrigger(this, project);
        ZigguratInject.inject((Object[])new Object[]{trigger});
        return trigger;
    }
}

