/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.document;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.Section;
import org.polarsys.reqcycle.core.ILogger;
import org.polarsys.reqcycle.repository.connector.document.DocRequirementModele;
import org.polarsys.reqcycle.repository.connector.document.DocSectionModele;
import org.polarsys.reqcycle.repository.connector.document.LogUtils;
import org.polarsys.reqcycle.repository.connector.ui.PropertyUtils;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingAttribute;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Requirement;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.repository.data.types.IAttribute;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.repository.data.types.internal.ETypeImpl;

public class DocParser {
    private StringBuffer document;
    private List<Section> sections;
    private HashMap<DocSectionModele, org.polarsys.reqcycle.repository.data.RequirementSourceData.Section> sectionMapping = new HashMap();
    @Inject
    ILogger logger;
    @Inject
    IDataManager manager;

    public void run(RequirementSource requirementSource) throws Exception {
        Scope scope = PropertyUtils.getScopeFromSource((RequirementSource)requirementSource);
        requirementSource.clearContent();
        ArrayList<DocRequirementModele> listReqModele = new ArrayList<DocRequirementModele>();
        ArrayList<DocSectionModele> listSectionModele = new ArrayList();
        String finalDoc = this.getFinalDocument();
        listSectionModele = this.createRequirementSections(requirementSource);
        if (listSectionModele != null) {
            Collections.sort(listSectionModele, new Comparator<DocSectionModele>(){

                @Override
                public int compare(DocSectionModele sec1, DocSectionModele sec2) {
                    return sec1.getPosition() < sec2.getPosition() ? -1 : (sec1.getPosition() > sec2.getPosition() ? 1 : 0);
                }
            });
            if (requirementSource.getMappings() != null) {
                for (MappingElement reqIn : requirementSource.getMappings()) {
                    Pattern pattern = Pattern.compile(reqIn.getSourceQualifier(), 40);
                    Matcher matcher = pattern.matcher(finalDoc);
                    while (matcher.find()) {
                        if (matcher.groupCount() > 0) {
                            if (LogUtils.isDebug()) {
                                System.out.println("req " + matcher.group(1) + " --- position : " + matcher.end());
                            }
                            listReqModele.add(new DocRequirementModele(matcher.end(), reqIn, matcher.group(1)));
                            continue;
                        }
                        if (LogUtils.isDebug()) {
                            LogUtils.log("req " + matcher.group() + " --- position : " + matcher.end());
                        }
                        listReqModele.add(new DocRequirementModele(matcher.end(), reqIn, matcher.group()));
                    }
                }
                if (listReqModele != null) {
                    Collections.sort(listReqModele, new Comparator<DocRequirementModele>(){

                        @Override
                        public int compare(DocRequirementModele req1, DocRequirementModele req2) {
                            return req1.getPosition() < req2.getPosition() ? -1 : (req1.getPosition() > req2.getPosition() ? 1 : 0);
                        }
                    });
                }
            }
        }
        System.out.println("FOUND " + listReqModele.size() + " REQUIREMENTS");
        System.out.println("------------------------------------------");
        int i = 0;
        while (i < listReqModele.size()) {
            IRequirementType requirementType = (IRequirementType)PropertyUtils.getDataModelFromSource((RequirementSource)requirementSource).getType(((DocRequirementModele)listReqModele.get(i)).getRequirement().getDescription());
            if (requirementType == null && LogUtils.isDebug()) {
                System.out.println("the requirementType " + requirementType + " is nul");
            }
            String startReq = ((DocRequirementModele)listReqModele.get(i)).getResult();
            int p1 = ((DocRequirementModele)listReqModele.get(i)).getPosition();
            int p2 = finalDoc.length();
            String endReq = "\\Z";
            if (i + 1 < listReqModele.size()) {
                endReq = ((DocRequirementModele)listReqModele.get(i + 1)).getResult();
                p2 = ((DocRequirementModele)listReqModele.get(i + 1)).getPosition();
            }
            Pattern patternS = Pattern.compile("(" + startReq + ".*?)" + endReq, 40);
            String docSectionToAnalyse = finalDoc.substring(p1 - startReq.length() - 1, p2);
            Matcher matcherS = patternS.matcher(docSectionToAnalyse);
            String documentSection = " ";
            while (matcherS.find()) {
                if (matcherS.groupCount() > 0) {
                    if (LogUtils.isDebug()) {
                        System.out.println("req " + matcherS.group(1) + " ------- position : " + matcherS.end());
                    }
                    documentSection = matcherS.group(1);
                    continue;
                }
                if (LogUtils.isDebug()) {
                    System.out.println("req " + matcherS.group() + " ------- position : " + matcherS.end());
                }
                documentSection = matcherS.group();
            }
            Pattern pattern = Pattern.compile(((DocRequirementModele)listReqModele.get(i)).getRequirement().getSourceQualifier(), 40);
            Matcher matcher = pattern.matcher(documentSection);
            while (matcher.find()) {
                Requirement requirement = requirementType.createInstance();
                if (matcher.groupCount() > 0) {
                    if (LogUtils.isDebug()) {
                        System.out.println(matcher.group(1));
                    }
                    String reqId = matcher.group(1);
                    requirement.setId(reqId);
                } else {
                    if (LogUtils.isDebug()) {
                        System.out.println(matcher.group());
                    }
                    requirement.setId(matcher.group());
                }
                requirement.getScopes().add((Object)scope);
                EList Attributes = ((DocRequirementModele)listReqModele.get(i)).getRequirement().getAttributes();
                for (final MappingAttribute att : Attributes) {
                    Pattern patternAtt = Pattern.compile(att.getSourceId(), 40);
                    Matcher matcherAtt = patternAtt.matcher(documentSection);
                    while (matcherAtt.find()) {
                        IAttribute attFromType = (IAttribute)Iterables.find((Iterable)requirementType.getAttributes(), (Predicate)new Predicate<IAttribute>(){

                            public boolean apply(IAttribute arg0) {
                                return arg0.getName().equals(att.getDescription());
                            }
                        }, null);
                        Object value = null;
                        if (attFromType == null) {
                            if (LogUtils.isDebug()) {
                                System.out.println("the attFromType " + attFromType + " is nul");
                            }
                        } else {
                            String stringFromDocument = null;
                            stringFromDocument = matcherAtt.groupCount() > 0 ? matcherAtt.group(1) : matcherAtt.group();
                            if (LogUtils.isDebug()) {
                                System.out.println("att : " + att.getDescription() + " :" + stringFromDocument);
                            }
                            value = this.getValueFromString(stringFromDocument, attFromType.getType());
                        }
                        this.manager.addAttributeValue((AbstractElement)requirement, attFromType, value);
                    }
                }
                org.polarsys.reqcycle.repository.data.RequirementSourceData.Section sect = this.findSectionForRequirement(((DocRequirementModele)listReqModele.get(i)).getPosition(), listSectionModele);
                String txt = requirement.getText();
                if (txt == null || txt.length() <= 0) continue;
                this.manager.addElementsToSection(sect, new AbstractElement[]{requirement});
            }
            ++i;
        }
    }

    private String getFinalDocument() {
        Pattern pat;
        Matcher matcher;
        String doc = this.document.toString();
        String regex = "#start_exclusion.*?#end_exclusion";
        if (this.document != null && (matcher = (pat = Pattern.compile(regex, 40)).matcher(this.document)).find()) {
            doc = matcher.replaceAll(" ");
        }
        return doc;
    }

    private org.polarsys.reqcycle.repository.data.RequirementSourceData.Section findSectionForRequirement(int positionReq, List<DocSectionModele> listSectionModele) {
        int i = 0;
        while (i < listSectionModele.size()) {
            if (i + 1 == listSectionModele.size() ? listSectionModele.get(i).getPosition() <= positionReq : i + 1 < listSectionModele.size() && listSectionModele.get(i).getPosition() <= positionReq && positionReq < listSectionModele.get(i + 1).getPosition()) {
                return this.sectionMapping.get(listSectionModele.get(i));
            }
            ++i;
        }
        return null;
    }

    private Object getValueFromString(String stringFromDocument, IType attributeType) {
        if (attributeType.getName().equalsIgnoreCase(ETypeImpl.BOOLEAN.getName())) {
            return Boolean.valueOf(stringFromDocument);
        }
        if (attributeType.getName().equalsIgnoreCase(ETypeImpl.STRING.getName())) {
            return stringFromDocument;
        }
        if (attributeType.getName().equalsIgnoreCase(ETypeImpl.INT.getName())) {
            return Integer.valueOf(stringFromDocument);
        }
        return null;
    }

    private List<DocSectionModele> createRequirementSections(RequirementSource requirementSource) {
        ArrayList<DocSectionModele> listSections = new ArrayList<DocSectionModele>();
        int[] occurenceInChapters = new int[10];
        int lastLevel = 0;
        String chapterNumber = "";
        org.polarsys.reqcycle.repository.data.RequirementSourceData.Section reqSection = null;
        String chapterLabel = "";
        for (Section sect : this.sections) {
            int level = Integer.parseInt(sect.getHiearchy());
            if (level >= 1) {
                chapterNumber = "";
                if (level > lastLevel) {
                    occurenceInChapters[level] = 1;
                } else {
                    int n = level;
                    occurenceInChapters[n] = occurenceInChapters[n] + 1;
                }
                int i = 1;
                while (i < level + 1) {
                    chapterNumber = String.valueOf(chapterNumber) + occurenceInChapters[i] + ".";
                    ++i;
                }
                chapterLabel = sect.getTitle().getTextContent();
                int approximatedOffset = Integer.parseInt(sect.getTitle().getStyleName());
                int offsetInDocument = this.findRightOffsetFromChapterNameAndApproximatedOffset(chapterLabel, approximatedOffset);
                DocSectionModele sectionModeleP = new DocSectionModele(chapterLabel, sect.getParent().getTitle().getTextContent(), offsetInDocument, null);
                listSections.add(sectionModeleP);
                reqSection = this.manager.createSection(chapterNumber, chapterLabel, null);
                if (reqSection != null) {
                    this.manager.addElementsToSource(requirementSource, new AbstractElement[]{reqSection});
                    this.sectionMapping.put(sectionModeleP, reqSection);
                }
            }
            lastLevel = level;
        }
        return listSections;
    }

    private int findRightOffsetFromChapterNameAndApproximatedOffset(String chapterLabel, int approximatedOffset) {
        int previousOffset = 0;
        Pattern patternP = Pattern.compile(chapterLabel, 40);
        Matcher matcherP = patternP.matcher(this.document);
        while (matcherP.find()) {
            int currentOffset = matcherP.end();
            if (currentOffset > approximatedOffset) {
                return previousOffset;
            }
            previousOffset = currentOffset;
        }
        if (previousOffset > approximatedOffset - 500) {
            return previousOffset;
        }
        System.out.println(" could not find a matching chapter for label " + chapterLabel + " for approximate offset " + approximatedOffset + " . Returning approximate offset");
        return approximatedOffset;
    }

    public StringBuffer getDocument() {
        return this.document;
    }

    public void setDocument(StringBuffer document) {
        this.document = document;
    }

    public void setSections(List<Section> sections) {
        this.sections = sections;
    }

    public List<Section> getSections() {
        return this.sections;
    }
}

