/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.repository.data.ScopeConf.ScopeConfFactory;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scopes;
import org.polarsys.reqcycle.repository.data.types.IAttribute;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IEnumerationType;
import org.polarsys.reqcycle.repository.data.types.IEnumerator;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.repository.data.types.internal.AttributeImpl;
import org.polarsys.reqcycle.repository.data.types.internal.DataModelImpl;
import org.polarsys.reqcycle.repository.data.types.internal.EnumerationTypeImpl;
import org.polarsys.reqcycle.repository.data.types.internal.EnumeratorImpl;
import org.polarsys.reqcycle.repository.data.types.internal.RequirementTypeImpl;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;

@Singleton
public class DataModelManagerImpl
implements IDataModelManager {
    protected IDataModel containerDataModel;
    @Inject
    IConfigurationManager confManager;
    static final String DATAMODELS_CONF_ID = "org.polarsys.reqcycle.data.datamodels";
    static final String SCOPES_CONF_ID = "org.polarsys.reqcycle.data.scopes";
    protected Scopes scopes;

    @Inject
    DataModelManagerImpl(IConfigurationManager confManager) {
        this.confManager = confManager;
        this.initTypes();
        this.initScopes();
    }

    protected void initScopes() {
        Collection conf = this.confManager.getConfiguration(null, null, SCOPES_CONF_ID, null, null, true);
        EObject element = null;
        if (conf != null && !conf.isEmpty()) {
            element = (EObject)conf.iterator().next();
        }
        if (element instanceof Scopes) {
            this.scopes = (Scopes)element;
        } else {
            this.scopes = ScopeConfFactory.eINSTANCE.createScopes();
            this.saveScopes();
        }
    }

    protected void initTypes() {
        EPackage ePackage;
        Collection conf = this.confManager.getConfiguration(null, IConfigurationManager.Scope.WORKSPACE, DATAMODELS_CONF_ID, null, "ecore", true);
        EObject element = null;
        if (conf != null && !conf.isEmpty()) {
            element = (EObject)conf.iterator().next();
        }
        if (element instanceof EPackage) {
            ePackage = (EPackage)element;
            this.containerDataModel = new DataModelImpl(ePackage);
        } else {
            ePackage = EcoreFactory.eINSTANCE.createEPackage();
            ePackage.setName("DataModels");
            ePackage.setNsPrefix("DataModels");
            ePackage.setNsURI("http://www.polarsys.org/ReqCycle/CustomDataModels");
            this.containerDataModel = new DataModelImpl(ePackage);
            this.saveDataModels();
        }
        this.registerDataModels(ePackage);
    }

    @Override
    public void discardUnsavedChanges() {
        this.initTypes();
    }

    @Override
    public void save() {
        this.saveDataModels();
        this.saveScopes();
    }

    protected void saveScopes() {
        try {
            this.confManager.saveConfiguration(Collections.singleton(this.scopes), null, null, SCOPES_CONF_ID, null, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void saveDataModels() {
        for (IDataModel dataModel : Lists.newArrayList(this.getAllDataModels())) {
            DataModelImpl oldDataModel = ((DataModelImpl)dataModel).prepareSave();
            if (oldDataModel == null) continue;
            ((DataModelImpl)this.containerDataModel).addSubDataModel(oldDataModel);
        }
        try {
            EPackage ePackage = null;
            if (this.containerDataModel instanceof IAdaptable) {
                ePackage = (EPackage)((IAdaptable)this.containerDataModel).getAdapter(EPackage.class);
            }
            this.confManager.saveConfiguration(Collections.singleton(ePackage), null, IConfigurationManager.Scope.WORKSPACE, DATAMODELS_CONF_ID, null, "ecore");
            this.registerDataModels(ePackage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public IDataModel createDataModel(String name) {
        DataModelImpl dataModel = new DataModelImpl(name, 1);
        this.addDataModel(dataModel);
        return dataModel;
    }

    @Override
    public void addDataModel(IDataModel p) {
        if (p == null) {
            return;
        }
        if (this.getCurrentDataModel(p.getName()) != null) {
            throw new RuntimeException("A data model with the uri name already exists.");
        }
        ((DataModelImpl)this.containerDataModel).addSubDataModel(p);
    }

    @Override
    public void removeDataModel(IDataModel p) {
        if (p == null) {
            return;
        }
        ((DataModelImpl)this.containerDataModel).removeSubDataModel(p);
        this.getScopes(this.containerDataModel);
    }

    public void removeScope(Scope ... scopes) {
        this.scopes.getScopes().removeAll(Arrays.asList(scopes));
    }

    protected void registerDataModels(EPackage ePackage) {
        EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
        for (EPackage p : ePackage.getESubpackages()) {
            EPackage.Registry.INSTANCE.put((Object)p.getNsURI(), (Object)p);
        }
    }

    @Override
    public IDataModel getCurrentDataModel(String name) {
        IDataModel matchingDataModel = null;
        for (IDataModel dataModel : this.getAllDataModels()) {
            if (!name.equals(dataModel.getName()) || !this.isNewer(matchingDataModel, dataModel)) continue;
            matchingDataModel = dataModel;
        }
        return matchingDataModel;
    }

    public Collection<IDataModel> getAllVersionsOfDataModel(String name) {
        ArrayList matchingDataModels = Lists.newArrayList();
        for (IDataModel dataModel : this.getAllDataModels()) {
            if (!name.equals(dataModel.getName())) continue;
            matchingDataModels.add(dataModel);
        }
        return matchingDataModels;
    }

    protected boolean isNewer(IDataModel ref, IDataModel toCompare) {
        return ref == null || toCompare.getVersion() > ref.getVersion();
    }

    @Override
    public Collection<IDataModel> getCurrentDataModels() {
        HashMap nameToDataModels = Maps.newHashMap();
        for (IDataModel dataModel : this.getAllDataModels()) {
            IDataModel matchingDataModel = (IDataModel)nameToDataModels.get(dataModel.getName());
            if (matchingDataModel != null && !this.isNewer(matchingDataModel, dataModel)) continue;
            nameToDataModels.put(dataModel.getName(), dataModel);
        }
        return nameToDataModels.values();
    }

    public Collection<IDataModel> getAllDataModels() {
        Assert.isNotNull((Object)this.containerDataModel);
        return ((DataModelImpl)this.containerDataModel).getSubDataModels();
    }

    @Override
    public IRequirementType createRequirementType(String name, IDataModel dataModel) {
        RequirementTypeImpl element = new RequirementTypeImpl(name, dataModel);
        return element;
    }

    @Override
    public IEnumerationType createEnumerationType(String name) {
        EnumerationTypeImpl element = new EnumerationTypeImpl(name);
        return element;
    }

    @Override
    public IEnumerator createEnumerator(String name) {
        EnumeratorImpl enumeratorType = new EnumeratorImpl(name);
        return enumeratorType;
    }

    @Override
    public IAttribute createAttribute(String name, IType type, boolean isMany) {
        return new AttributeImpl(name, type, isMany);
    }

    @Override
    public Scope createScope(String name, IDataModel dataModel) {
        Scope scope = ScopeConfFactory.eINSTANCE.createScope();
        scope.setName(name);
        scope.setDataModelName(dataModel.getName());
        return scope;
    }

    @Override
    public void addScopes(IDataModel dataModel, Scope ... scopes) {
        Scope[] scopeArray = scopes;
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            Scope scope = scopeArray[n2];
            this.scopes.getScopes().add((Object)scope);
            ++n2;
        }
    }

    @Override
    public Collection<Scope> getAllScopes() {
        return this.scopes.getScopes();
    }

    @Override
    public Collection<Scope> getScopes(final IDataModel dataModel) {
        return Collections2.filter(this.scopes.getScopes(), (Predicate)new Predicate<Scope>(){

            public boolean apply(Scope arg0) {
                return arg0.getDataModelName().equals(dataModel.getName());
            }
        });
    }

    @Override
    public Scope getScope(String name, IDataModel dataModel) {
        for (Scope s : this.scopes.getScopes()) {
            if (!s.getDataModelName().equals(dataModel.getName()) || !s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    @Override
    public IDataModel getDataModelByURI(String uri) {
        for (IDataModel dataModel : this.getAllDataModels()) {
            if (!uri.equals(dataModel.getDataModelURI())) continue;
            return dataModel;
        }
        return null;
    }

    @Override
    public boolean isEmpty(IDataModel dataModel) {
        return dataModel.getTypes().isEmpty();
    }

    @Override
    public IRequirementType getType(AbstractElement ae) {
        EPackage ep;
        EClass eClass = ae.eClass();
        ECrossReferenceAdapter c = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)eClass);
        if (c == null && eClass.eResource() != null) {
            c = new ECrossReferenceAdapter();
            if (eClass.eResource() != null && eClass.eResource().getResourceSet() != null) {
                eClass.eResource().getResourceSet().eAdapters().add((Object)c);
            }
        }
        if (c != null) {
            Collection settings = c.getInverseReferences((EObject)eClass);
            for (EStructuralFeature.Setting setting : settings) {
                EObject eo = setting.getEObject();
                if (!(eo instanceof IRequirementType)) continue;
                return (IRequirementType)eo;
            }
        }
        if ((ep = eClass.getEPackage()) != null) {
            for (IDataModel d : this.getAllDataModels()) {
                DataModelImpl imp;
                EPackage dmEP;
                if (!(d instanceof DataModelImpl) || (dmEP = (EPackage)(imp = (DataModelImpl)d).getAdapter(EPackage.class)) == null || !dmEP.getNsURI().equals(ep.getNsURI())) continue;
                for (RequirementTypeImpl t : Iterables.filter(d.getTypes(), RequirementTypeImpl.class)) {
                    if (!t.getEType().equals(eClass)) continue;
                    return t;
                }
            }
        }
        return null;
    }
}

