/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.local;

import javax.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class EditRequirementsHandler
extends AbstractHandler {
    @Inject
    IConfigurationManager confManager;

    public EditRequirementsHandler() {
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object firstElement;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof RequirementSource) {
            RequirementSource requirementSource = (RequirementSource)firstElement;
            String connectorId = requirementSource.getConnectorId();
            if ("org.polarsys.reqcycle.repository.connector.local.connectorCore".equals(connectorId)) {
                IEditorReference[] editorReferences;
                Resource eResource = requirementSource.getContents().eResource();
                IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference iEditorReference = iEditorReferenceArray[n2];
                    try {
                        IURIEditorInput input;
                        if (iEditorReference.getEditorInput() instanceof IURIEditorInput && (input = (IURIEditorInput)iEditorReference.getEditorInput()).getURI().equals(eResource.getURI())) {
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Open Requirement Editor", (String)"Please close the opened Requirements Editor before beginning a new edition.");
                            return null;
                        }
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    URIEditorInput editorInput = new URIEditorInput(eResource.getURI());
                    IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)"org.polarsys.reqcycle.repository.data.ui.editor");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            } else {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Open Requiement Editor", (String)"Can't Edit this Requirement Source. Only Local Requirement Source can be edited.");
                return null;
            }
        }
        return null;
    }
}

