/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.cache.emfbased.pickers;

import com.google.common.base.Predicate;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.UUID;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.polarsys.reqcycle.traceability.cache.emfbased.functions.Traceable2TraceableElement;
import org.polarsys.reqcycle.traceability.cache.emfbased.functions.TraceableElement2Traceable;
import org.polarsys.reqcycle.traceability.cache.emfbased.model.CacheTracability.Model;
import org.polarsys.reqcycle.traceability.cache.emfbased.model.CacheTracability.TraceabilityLink;
import org.polarsys.reqcycle.traceability.cache.emfbased.model.CacheTracability.TraceableElement;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;
import org.polarsys.reqcycle.utils.iterators.exceptions.PickerExecutionException;
import org.polarsys.reqcycle.utils.iterators.pickers.IPicker;

public class TraceableElementPicker
implements IPicker {
    private ITraceabilityEngine.DIRECTION d;
    private Model theModel;
    private Predicate<Pair<Link, Reachable>> scope;
    @Inject
    IReachableManager manager;
    @Inject
    IReachableCreator creator;

    public TraceableElementPicker(ITraceabilityEngine.DIRECTION d, Model m, Predicate<Pair<Link, Reachable>> scope) {
        this.d = d;
        this.theModel = m;
        this.scope = scope;
    }

    public Iterable<?> getNexts(Object element) throws PickerExecutionException {
        ArrayDeque<Pair> result = new ArrayDeque<Pair>();
        TraceableElement elem = null;
        if (element instanceof TraceableElement) {
            elem = (TraceableElement)element;
        }
        if (element instanceof Pair) {
            Pair pair = (Pair)element;
            elem = new Traceable2TraceableElement(this.theModel).apply((Reachable)pair.getSecond());
        }
        TraceableElement2Traceable traceableElement2Traceable = new TraceableElement2Traceable();
        ZigguratInject.inject((Object[])new Object[]{traceableElement2Traceable});
        if (elem != null) {
            EList<TraceabilityLink> list = null;
            list = this.d == ITraceabilityEngine.DIRECTION.UPWARD ? elem.getOutgoings() : elem.getIncomings();
            for (TraceabilityLink l : list) {
                EList<TraceableElement> list2 = null;
                list2 = this.d == ITraceabilityEngine.DIRECTION.UPWARD ? l.getTargets() : l.getSources();
                for (TraceableElement t : list2) {
                    Reachable source = traceableElement2Traceable.apply(elem);
                    Reachable target = traceableElement2Traceable.apply(t);
                    URI uri = null;
                    try {
                        uri = new URI(l.getResource().getUri());
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    Reachable r = this.creator.getReachable(uri);
                    UUID uniqueID = UUID.randomUUID();
                    Pair pair = new Pair((Object)new Link(r, new TType(uniqueID.toString(), l.getLabel()), Collections.singleton(source), Collections.singleton(target)), (Object)target);
                    if (!this.scope.apply((Object)pair)) continue;
                    result.add(pair);
                }
            }
        }
        return result;
    }
}

