/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.impact.ui.dialogs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.polarsys.reqcycle.impact.Impact.AttributeImpacted;
import org.polarsys.reqcycle.impact.Impact.RequirementImpacted;
import org.polarsys.reqcycle.impact.Impact.TraceabilityLink;
import org.polarsys.reqcycle.impact.ui.Activator;
import org.polarsys.reqcycle.impact.ui.providers.ImpactContentProvider;
import org.polarsys.reqcycle.impact.ui.providers.ImpactLabelProvider;
import org.polarsys.reqcycle.impact.ui.providers.ImpactTraceabilityLabelProvider;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class ImpactAnalysisComposites {
    @Inject
    ITraceabilityEngine engine;
    @Inject
    IReachableManager manager;
    private Label rsValueLabel;
    private Label initialVersionValueLabel;
    private Label finalVersionValueLabel;
    private Label informationMessage;
    private Collection<TraceabilityLink> links = Lists.newArrayList();
    private ArrayList<ImpactContainer> impactList = Lists.newArrayList();
    private TreeViewer treeViewer;
    private TreeViewer attributeList;
    private TableViewer linkViewer;

    public ImpactAnalysisComposites() {
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    public Composite createInputComposite(Composite parent) {
        Composite inputComposite = new Composite(parent, 0);
        inputComposite.setLayout((Layout)new GridLayout(2, false));
        GridData gd_inputComposite = new GridData(4, 4, true, false, 1, 1);
        gd_inputComposite.heightHint = 73;
        inputComposite.setLayoutData((Object)gd_inputComposite);
        Label rsLabel = new Label(inputComposite, 0);
        rsLabel.setText("Requirement Source :");
        this.rsValueLabel = new Label(inputComposite, 0);
        this.rsValueLabel.setEnabled(false);
        this.rsValueLabel.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label initialVersionLabel = new Label(inputComposite, 0);
        initialVersionLabel.setText("Initial version for impact analysis :");
        this.initialVersionValueLabel = new Label(inputComposite, 0);
        this.initialVersionValueLabel.setEnabled(false);
        this.initialVersionValueLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Label finalVersionLabel = new Label(inputComposite, 0);
        finalVersionLabel.setText("Final version for impact analysis :");
        this.finalVersionValueLabel = new Label(inputComposite, 0);
        this.finalVersionValueLabel.setEnabled(false);
        this.finalVersionValueLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        return inputComposite;
    }

    public void setRequirementSource(String requirementSource) {
        this.rsValueLabel.setText(requirementSource);
    }

    public void setInitialVersion(String initialVersion) {
        this.initialVersionValueLabel.setText(initialVersion);
    }

    public void setFinalVersion(String finalVersion) {
        this.finalVersionValueLabel.setText(finalVersion);
    }

    public Composite createImpactComposite(Composite parent) {
        Composite impactResultComposite = new Composite(parent, 0);
        impactResultComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        impactResultComposite.setLayout((Layout)new GridLayout(1, false));
        SashForm form = new SashForm(impactResultComposite, 0);
        form.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer = new TreeViewer((Composite)form, 2048);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ImpactLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new ImpactContentProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (((IStructuredSelection)event.getSelection()).getFirstElement() instanceof RequirementImpacted) {
                    RequirementImpacted req = (RequirementImpacted)((IStructuredSelection)event.getSelection()).getFirstElement();
                    ImpactAnalysisComposites.this.attributeList.setInput((Object)req);
                    ImpactAnalysisComposites.this.attributeList.expandAll();
                    ImpactAnalysisComposites.this.links.clear();
                    ImpactAnalysisComposites.this.links.addAll(req.getLinkList());
                    ImpactAnalysisComposites.this.linkViewer.refresh();
                }
            }
        });
        this.attributeList = new TreeViewer((Composite)form, 2048);
        Tree tree2 = this.attributeList.getTree();
        tree2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.attributeList.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        this.attributeList.setContentProvider((IContentProvider)new AttributeContentProvider());
        this.linkViewer = new TableViewer((Composite)form, 2818);
        this.linkViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        ArrayContentProvider provider = ArrayContentProvider.getInstance();
        this.linkViewer.setContentProvider((IContentProvider)provider);
        Table table = this.linkViewer.getTable();
        this.linkViewer.setInput(this.links);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.informationMessage = new Label(impactResultComposite, 0);
        this.informationMessage.setText("");
        this.informationMessage.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createModel();
        return impactResultComposite;
    }

    public void setImpactResult(EList<RequirementImpacted> reqAdded, EList<RequirementImpacted> reqDeleted, EList<RequirementImpacted> reqModified) {
        this.impactList.clear();
        if (reqAdded.size() != 0) {
            ImpactContainer added = new ImpactContainer("Added", reqAdded);
            this.impactList.add(added);
        }
        if (reqDeleted.size() != 0) {
            ImpactContainer deleted = new ImpactContainer("Deleted", reqDeleted);
            this.impactList.add(deleted);
        }
        if (reqModified.size() != 0) {
            ImpactContainer modified = new ImpactContainer("Modified", reqModified);
            this.impactList.add(modified);
        }
        this.attributeList.setInput(null);
        this.links.clear();
        this.linkViewer.refresh();
        if (this.impactList.size() != 0) {
            this.treeViewer.setInput(this.impactList);
            this.informationMessage.setText("");
        } else {
            this.treeViewer.setInput(null);
            this.informationMessage.setText("The versions are identical.");
        }
    }

    private void createModel() {
        this.createTableViewerColumn("Link type", 50, 0).setLabelProvider((CellLabelProvider)new ImpactTraceabilityLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TraceabilityLink) {
                    TraceabilityLink link = (TraceabilityLink)element;
                    return link.getLinkType();
                }
                return super.getText(element);
            }
        });
        this.createTableViewerColumn("Direction", 50, 1).setLabelProvider((CellLabelProvider)new ImpactTraceabilityLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TraceabilityLink) {
                    TraceabilityLink link = (TraceabilityLink)element;
                    return link.getLinkDirection();
                }
                return super.getText(element);
            }
        });
        this.createTableViewerColumn("Link to", 100, 2).setLabelProvider((CellLabelProvider)new ImpactTraceabilityLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TraceabilityLink) {
                    TraceabilityLink link = (TraceabilityLink)element;
                    return link.getLinkedElement();
                }
                return super.getText(element);
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, Integer bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.linkViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        if (bound != null) {
            column.setWidth(bound.intValue());
        }
        column.setResizable(true);
        column.setMoveable(false);
        return viewerColumn;
    }

    public class AttributeContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            if (inputElement instanceof RequirementImpacted) {
                return ((RequirementImpacted)inputElement).getAttributesImpacted().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AttributeImpacted) {
                Object[] listObjects = new Object[2];
                AttributeValue oldValue = new AttributeValue(((AttributeImpacted)parentElement).getOldValue(), Status.OLD_VALUE);
                listObjects[0] = oldValue;
                AttributeValue newValue = new AttributeValue(((AttributeImpacted)parentElement).getNewValue(), Status.NEW_VALUE);
                listObjects[1] = newValue;
                return listObjects;
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof AttributeImpacted;
        }
    }

    public class AttributeLabelProvider
    implements ILabelProvider {
        Image imageOldValue;
        Image imageNewValue;

        public AttributeLabelProvider() {
            ImageDescriptor descrNew = Activator.getImageDescriptor("icons/add_obj.gif");
            this.imageNewValue = descrNew.createImage();
            ImageDescriptor descrOld = Activator.getImageDescriptor("icons/remove_correction.gif");
            this.imageOldValue = descrOld.createImage();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            if (element instanceof AttributeValue) {
                if (((AttributeValue)element).getStatus().equals((Object)Status.NEW_VALUE)) {
                    return this.imageNewValue;
                }
                return this.imageOldValue;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof AttributeImpacted) {
                return ((AttributeImpacted)element).getId();
            }
            if (element instanceof RequirementImpacted) {
                return ((RequirementImpacted)element).getId();
            }
            if (element instanceof AttributeValue) {
                return ((AttributeValue)element).getValue();
            }
            return element.toString();
        }
    }

    protected class AttributeValue {
        String value;
        Status status;

        AttributeValue(String value, Status status) {
            this.value = value;
            this.status = status;
        }

        protected String getValue() {
            return this.value;
        }

        protected Status getStatus() {
            return this.status;
        }
    }

    public class ImpactContainer {
        private String name;
        EList<RequirementImpacted> reqList;

        public ImpactContainer(String name, EList<RequirementImpacted> reqList) {
            this.name = name;
            this.reqList = reqList;
        }

        public String getName() {
            return this.name;
        }

        public EList<RequirementImpacted> getReqList() {
            return this.reqList;
        }
    }

    protected static enum Status {
        OLD_VALUE,
        NEW_VALUE;

    }
}

