/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.ui.services.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.ide.ResourceUtil;
import org.polarsys.reqcycle.traceability.ui.services.ILocateService;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.IReachableHandler;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;

@Singleton
public class LocateService
implements ILocateService {
    @Inject
    IReachableManager reachableManager;

    @Override
    public boolean isOpenable(Reachable reachable) {
        ReachableObject fromReachable;
        block9: {
            block8: {
                block7: {
                    if (reachable == null) {
                        return false;
                    }
                    String protocol = reachable.getScheme();
                    if (!"http".equalsIgnoreCase(protocol) && !"https".equalsIgnoreCase(protocol)) break block7;
                    return true;
                }
                IReachableHandler handler = this.reachableManager.getHandlerFromReachable(reachable);
                fromReachable = handler.getFromReachable(reachable);
                IMarker marker = this.getMarker(fromReachable);
                if (marker == null) break block8;
                return true;
            }
            IFile file = this.getFile(fromReachable);
            if (file == null) break block9;
            return true;
        }
        try {
            File f = this.getFileExternal(fromReachable);
            if (f != null) {
                return true;
            }
        }
        catch (IReachableHandlerException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void open(Reachable reachable) throws Exception {
        if (reachable == null) {
            return;
        }
        try {
            File f;
            IFile file;
            IReachableHandler handler;
            ReachableObject fromReachable;
            IMarker marker;
            String protocol = reachable.getScheme();
            if ("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol)) {
                this.openBrowser(reachable);
            }
            if ((marker = this.getMarker(fromReachable = (handler = this.reachableManager.getHandlerFromReachable(reachable)).getFromReachable(reachable))) != null) {
                this.openIFileEditor(marker);
                marker.delete();
            }
            if ((file = this.getFile(fromReachable)) != null) {
                this.openIFileEditor(file);
            }
            if ((f = this.getFileExternal(fromReachable)) != null) {
                this.openFileEditor(f);
            }
        }
        catch (IReachableHandlerException e) {
            e.printStackTrace();
        }
    }

    protected void openFileEditor(File f) throws Exception {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(f.getAbsolutePath()));
        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
    }

    protected void openIFileEditor(IFile file) throws Exception {
        IMarker marker = file.createMarker("LOCATION");
        this.openIFileEditor(marker);
    }

    protected void openIFileEditor(IMarker marker) throws PartInitException, CoreException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = null;
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorInput input;
            IFile fileFromEditor;
            IEditorReference ref = iEditorReferenceArray[n2];
            if (ref.getEditor(false) != null && (fileFromEditor = ResourceUtil.getFile((IEditorInput)(input = ref.getEditorInput()))) != null && marker.getResource().equals((Object)fileFromEditor) && OpenStrategy.activateOnOpen()) {
                editor = ref.getEditor(true);
                page.activate((IWorkbenchPart)editor);
            }
            ++n2;
        }
        try {
            editor = IDE.openEditor((IWorkbenchPage)page, (IMarker)marker, (boolean)OpenStrategy.activateOnOpen());
        }
        catch (PartInitException partInitException) {}
        if (editor instanceof IGotoMarker) {
            ((IGotoMarker)editor).gotoMarker(marker);
        }
    }

    protected void openBrowser(Reachable reachable) throws Exception {
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = browserSupport.createBrowser(6, browserSupport.getExternalBrowser().getId(), "Browser", "");
            URI uri = reachable.getURI();
            browser.openURL(uri.toURL());
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {
            throw new Exception("impossible to open in browser " + reachable.toString());
        }
    }

    protected IFile getFile(ReachableObject reachable) {
        IFile res = (IFile)reachable.getAdapter(IFile.class);
        if (res == null) {
            res = (IFile)Platform.getAdapterManager().getAdapter((Object)reachable, IFile.class);
        }
        return res;
    }

    protected File getFileExternal(ReachableObject reachable) {
        File res = (File)reachable.getAdapter(File.class);
        if (res == null) {
            res = (File)Platform.getAdapterManager().getAdapter((Object)reachable, File.class);
        }
        return res;
    }

    protected IMarker getMarker(ReachableObject reachable) {
        IMarker res = (IMarker)reachable.getAdapter(IMarker.class);
        if (res == null) {
            res = (IMarker)Platform.getAdapterManager().getAdapter((Object)reachable, IMarker.class);
        }
        return res;
    }
}

