/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.ui.components;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.reqcycle.predicates.core.util.PredicatesAdapterFactory;
import org.polarsys.reqcycle.ui.eattrpropseditor.GenericEAttrPropsEditor;

public class SelectTypeDialog
extends TitleAreaDialog {
    private ListViewer listViewer;
    private Object type;
    private GenericEAttrPropsEditor attributeEditor;
    private Boolean isStrictTypeOf;
    private final Collection<EClass> eClassesOfModelToEdit;

    public SelectTypeDialog(Shell parentShell, Collection<EClass> eClassesOfModelToEdit) {
        super(parentShell);
        this.eClassesOfModelToEdit = eClassesOfModelToEdit;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        this.listViewer = new ListViewer(container, 67584);
        org.eclipse.swt.widgets.List list = this.listViewer.getList();
        list.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.initProviders(this.listViewer);
        this.listViewer.setInput((Object)this.eClassesOfModelToEdit.toArray());
        this.attributeEditor = new GenericEAttrPropsEditor(container, 0);
        this.attributeEditor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        List possibleValues = Collections.emptyList();
        this.attributeEditor.init("Is strict type of : ", Boolean.class, possibleValues);
        return container;
    }

    private void initProviders(ListViewer list) {
        PredicatesAdapterFactory adapterfactory = new PredicatesAdapterFactory();
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterfactory){

            public String getText(Object object) {
                if (object instanceof EClass) {
                    return ((EClass)object).getName();
                }
                return super.getText(object);
            }
        };
        ArrayContentProvider contentProvider = ArrayContentProvider.getInstance();
        list.setLabelProvider((IBaseLabelProvider)labelProvider);
        list.setContentProvider((IContentProvider)contentProvider);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (!this.attributeEditor.isEditionValid()) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Is strict type of must be selected");
                return;
            }
            if (this.listViewer.getSelection().isEmpty()) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"A type must be selected");
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
            this.type = selection.getFirstElement();
            this.isStrictTypeOf = (Boolean)this.attributeEditor.getEnteredValue();
        }
        super.buttonPressed(buttonId);
    }

    public Object getResult() {
        return this.type;
    }

    public Boolean getIsStrictTypeOf() {
        return this.isStrictTypeOf;
    }
}

