/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.util;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.polarsys.reqcycle.core.ILogger;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingAttribute;
import org.polarsys.reqcycle.repository.data.MappingModel.MappingElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Section;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;

public class DataUtil {
    @Inject
    static IDataManager requirementSourceManager;
    @Inject
    static ILogger logger;
    protected static ComposedAdapterFactory cAdapterFactory;
    public static LabelProvider labelProvider;
    static Joiner joiner;
    static Splitter splitter;

    static {
        cAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return DataUtil.getLabel(element);
            }

            public Image getImage(Object element) {
                return DataUtil.getImage(element);
            }
        };
        joiner = Joiner.on((String)"::");
        splitter = Splitter.on((String)"::");
    }

    public static String getLabel(Object obj) {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)cAdapterFactory.adapt(obj, IItemLabelProvider.class);
        if (itemLabelProvider != null) {
            return itemLabelProvider.getText(obj);
        }
        if (obj instanceof Scope) {
            return ((Scope)obj).eClass().getName();
        }
        return obj.toString();
    }

    public static Image getImage(Object obj) {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)cAdapterFactory.adapt(obj, IItemLabelProvider.class);
        if (itemLabelProvider != null) {
            return null;
        }
        return null;
    }

    public static String getInformation(AbstractElement object) {
        String result = "";
        EList structuralFeatures = object.eClass().getEStructuralFeatures();
        if (object.getId() != null && !object.getId().isEmpty()) {
            result = String.valueOf(result) + " id : " + object.getId() + " ";
        }
        if (object.getText() != null && !object.getText().isEmpty()) {
            if (!result.isEmpty()) {
                result = String.valueOf(result) + " | ";
            }
            result = String.valueOf(result) + " name : " + object.getText() + " ";
        }
        for (EStructuralFeature eStructuralFeature : structuralFeatures) {
            if (eStructuralFeature instanceof EReference || object.eGet(eStructuralFeature) == null) continue;
            result = String.valueOf(result) + "[ " + eStructuralFeature.getName() + " : " + object.eGet(eStructuralFeature) + "]";
        }
        if (result.isEmpty()) {
            result = "Requirement Type : " + object.eClass().getName() + " [ this element doesn't have any attribute ]";
        }
        return result;
    }

    public static List<String> getQualifiedPath(AbstractElement element) {
        AbstractElement currentElement = element;
        ArrayList res = Lists.newArrayList();
        while (currentElement != null) {
            if (currentElement instanceof AbstractElement) {
                res.add(0, currentElement.getId());
            }
            currentElement = currentElement.eContainer();
        }
        return res;
    }

    public static String getFlattenedQualifiedPath(AbstractElement element) {
        return joiner.join(DataUtil.getQualifiedPath(element));
    }

    public static AbstractElement getElement(Resource r, String flattenedQualifiedNamePath) {
        return DataUtil.getElement((Collection<EObject>)r.getContents(), (List<String>)Lists.newArrayList((Iterable)splitter.split((CharSequence)flattenedQualifiedNamePath)));
    }

    public static AbstractElement getElement(EObject root, List<String> qualifiedNamePath) {
        return DataUtil.getElement((Collection<EObject>)root.eContents(), qualifiedNamePath);
    }

    public static AbstractElement getElement(Collection<EObject> roots, List<String> qualifiedNamePath) {
        if (!qualifiedNamePath.isEmpty()) {
            String firstName = qualifiedNamePath.get(0);
            for (EObject obj : roots) {
                if (!(obj instanceof AbstractElement) || !firstName.equals(((AbstractElement)obj).getId())) continue;
                if (qualifiedNamePath.size() > 1) {
                    ArrayList newQualifiedNamePath = Lists.newArrayList(qualifiedNamePath);
                    newQualifiedNamePath.remove(0);
                    return DataUtil.getElement((Collection<EObject>)obj.eContents(), (List<String>)newQualifiedNamePath);
                }
                return (AbstractElement)obj;
            }
        }
        return null;
    }

    public static MappingAttribute getAttributeMapping(MappingElement mappingElement, String id, String longName) {
        for (MappingAttribute attribute : mappingElement.getAttributes()) {
            if (id != null && id.equals(attribute.getSourceId())) {
                return attribute;
            }
            if (longName == null || !longName.equals(attribute.getDescription())) continue;
            return attribute;
        }
        return null;
    }

    public static MappingElement getElementMapping(Collection<MappingElement> mapping, String qualifier, String longName) {
        for (MappingElement mappingElement : mapping) {
            if (qualifier != null && qualifier.equals(mappingElement.getSourceQualifier())) {
                return mappingElement;
            }
            if (longName == null || !longName.equals(mappingElement.getDescription())) continue;
            return mappingElement;
        }
        return null;
    }

    public static Collection<AbstractElement> getAllContainedElements(EList<AbstractElement> elements) {
        ArrayList<AbstractElement> result = new ArrayList<AbstractElement>();
        result.addAll((Collection<AbstractElement>)elements);
        for (AbstractElement element : elements) {
            if (!(element instanceof Section)) continue;
            result.addAll(DataUtil.getAllContainedElements(((Section)element).getChildren()));
        }
        return result;
    }

    public static Collection<EClassifier> getTargetEPackage(ResourceSet resourceSet, String modelLocation) {
        URI uriAttributeModel = URI.createPlatformPluginURI((String)modelLocation, (boolean)false);
        Resource attributeModelResource = resourceSet.getResource(uriAttributeModel, true);
        EList modelContent = attributeModelResource.getContents();
        if (modelContent.size() > 0) {
            ArrayList<EClassifier> result = new ArrayList<EClassifier>();
            for (EObject eObject : modelContent) {
                if (!(eObject instanceof EPackage)) continue;
                Collection filtered = Collections2.filter((Collection)((EPackage)eObject).getEClassifiers(), (Predicate)new Predicate<EClassifier>(){

                    public boolean apply(EClassifier arg0) {
                        if (arg0 instanceof EClass) {
                            EList superTypes = ((EClass)arg0).getEAllSuperTypes();
                            for (EClassifier superType : superTypes) {
                                if (!"AbstractElement".equals(superType.getName())) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                });
                result.addAll(filtered);
            }
            return result;
        }
        return null;
    }

    public static Collection<RequirementSource> getRepositories(Object obj) {
        if (obj instanceof String && requirementSourceManager.getRequirementSources((String)obj) != null) {
            return requirementSourceManager.getRequirementSources((String)obj);
        }
        if (obj instanceof RequirementSource) {
            return Arrays.asList((RequirementSource)obj);
        }
        return Collections.emptyList();
    }
}

