/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.polarsys.reqcycle.core.ILogger;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSourceConfFactory;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSources;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Requirement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.RequirementSourceDataFactory;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.RequirementsContainer;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Section;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Trash;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.repository.data.types.IAttribute;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;
import org.polarsys.reqcycle.utils.configuration.impl.EMFConfResourceFactory;

@Singleton
public class DataManagerImpl
implements IDataManager,
IResourceChangeListener,
IResourceDeltaVisitor {
    protected static final Map<?, ?> SAVE_OPTIONS = Collections.emptyMap();
    private Map<String, Set<RequirementSource>> repositoryMap = new HashMap<String, Set<RequirementSource>>();
    private RequirementSources sources;
    @Inject
    IConfigurationManager confManager;
    public static final String SOURCES_CONF_ID = "org.polarsys.reqcycle.repositories";
    public static final String CONTENTS_CONF_ID = "org.polarsys.reqcycle.repositories.contents";
    @Inject
    IEventBroker broker;
    @Inject
    ILogger logger;
    @Inject
    IDataModelManager dataModelManager;

    @PostConstruct
    void init() {
        Collection conf = this.confManager.getConfiguration(null, IConfigurationManager.Scope.WORKSPACE, SOURCES_CONF_ID, null, null, true);
        EObject element = null;
        if (conf != null && !conf.isEmpty()) {
            element = (EObject)conf.iterator().next();
        }
        if (element instanceof RequirementSources) {
            this.sources = (RequirementSources)element;
            EList<RequirementSource> RequirementSources2 = this.sources.getRequirementSources();
            for (RequirementSource requirementSourceRepository : RequirementSources2) {
                String connectorId = requirementSourceRepository.getConnectorId();
                if (this.repositoryMap.containsKey(connectorId)) {
                    this.repositoryMap.get(connectorId).add(requirementSourceRepository);
                    continue;
                }
                HashSet<RequirementSource> set = new HashSet<RequirementSource>();
                set.add(requirementSourceRepository);
                this.repositoryMap.put(connectorId, set);
            }
        } else {
            this.sources = RequirementSourceConfFactory.eINSTANCE.createRequirementSources();
        }
        this.initWorkspaceListener();
    }

    private void initWorkspaceListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    @Override
    public void addRequirementSource(RequirementSource repository) {
        Set<RequirementSource> repositories = this.repositoryMap.get(repository.getConnectorId());
        if (repositories == null) {
            repositories = new HashSet<RequirementSource>();
            this.repositoryMap.put(repository.getConnectorId(), repositories);
        }
        if (!repositories.contains(repository)) {
            repositories.add(repository);
        }
        if (!this.sources.getRequirementSources().contains((Object)repository)) {
            this.sources.getRequirementSources().add((Object)repository);
        }
        try {
            this.save();
            this.notifyChange("TOPIC_REQCYCLE_DATA/NEW/SOURCE", repository);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.log((IStatus)new Status(4, "org.polarsys.reqcycle.repository.data", e.getMessage()));
        }
    }

    private <T extends EObject> T resolveProxy(T obj) {
        if (obj.eIsProxy() && obj.eResource() != null) {
            EObject newObj = EcoreUtil.resolve(obj, (ResourceSet)obj.eResource().getResourceSet());
            return (T)newObj;
        }
        return obj;
    }

    @Override
    public void removeRequirementSource(RequirementSource repository, boolean removeFromWS) {
        Set<RequirementSource> repositories = this.repositoryMap.get(repository.getConnectorId());
        if (repositories != null) {
            Resource resource;
            RequirementsContainer contents = repository.getContents();
            if (contents != null && (resource = (contents = this.resolveProxy(contents)).eResource()) != null && WorkspaceSynchronizer.getFile((Resource)resource) != null && removeFromWS && resource != null) {
                try {
                    if (resource.isLoaded()) {
                        resource.unload();
                    }
                    resource.delete(Collections.emptyMap());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            repositories.remove(repository);
            this.sources.removeRequirementSource(repository);
            repository.clearContent();
            EcoreUtil.delete((EObject)repository, (boolean)true);
            try {
                this.save();
                this.notifyChange("TOPIC_REQCYCLE_DATA/REMOVE/SOURCE", repository);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.logger.log((IStatus)new Status(4, "org.polarsys.reqcycle.repository.data", e.getMessage()));
            }
        }
    }

    @Override
    public void save() throws IOException {
        this.saveContents();
        this.saveSources();
    }

    protected void saveSources() throws IOException {
        this.confManager.saveConfiguration(Collections.singleton(this.sources), null, null, SOURCES_CONF_ID, null, null);
    }

    protected void saveContents() throws IOException {
        for (RequirementSource source : this.sources.getRequirementSources()) {
            if (source.getDestinationURI() == null) {
                this.confManager.saveConfiguration(Collections.singleton(source.getContents()), null, null, "org.polarsys.reqcycle.repositories.contents." + source.getName(), null, "reqcycle");
                continue;
            }
            RequirementsContainer reqContainer = source.getContents();
            Resource eResource = reqContainer.eResource();
            if (eResource == null) {
                eResource = this.confManager.getConfigurationResourceSet().createResource(URI.createURI((String)source.getDestinationURI()));
                eResource.getContents().add((Object)reqContainer);
            }
            if (eResource instanceof EMFConfResourceFactory.EMFConfResource) {
                ((EMFConfResourceFactory.EMFConfResource)eResource).manualSave(SAVE_OPTIONS);
                continue;
            }
            if (eResource == null) continue;
            eResource.save(SAVE_OPTIONS);
        }
    }

    @Override
    public void removeRequirementSources(String connectorId) {
        Set<RequirementSource> repositories = this.repositoryMap.get(connectorId);
        for (RequirementSource reqSource : repositories) {
            this.sources.removeRequirementSource(reqSource);
            reqSource.clearContent();
            this.notifyChange("TOPIC_REQCYCLE_DATA/REMOVE/ELEMENT/REQUIREMENT", reqSource);
        }
        try {
            this.save();
            this.repositoryMap.remove(connectorId);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.log((IStatus)new Status(4, "org.polarsys.reqcycle.repository.data", e.getMessage()));
        }
    }

    @Override
    public RequirementSource getRequirementSource(String connectorId, String repositoryUri) {
        Assert.isNotNull((Object)connectorId);
        Assert.isNotNull((Object)repositoryUri);
        if (this.repositoryMap.containsKey(connectorId)) {
            for (RequirementSource repository : this.repositoryMap.get(connectorId)) {
                if (!repository.getRepositoryURI().equals(repositoryUri)) continue;
                return repository;
            }
        }
        return null;
    }

    @Override
    public Set<RequirementSource> getRequirementSources(String connectorId) {
        Assert.isNotNull((Object)connectorId);
        Set<RequirementSource> result = this.repositoryMap.get(connectorId);
        if (result == null) {
            return Collections.emptySet();
        }
        return new HashSet<RequirementSource>(result);
    }

    @Override
    public Map<String, Set<RequirementSource>> getRepositoryMap() {
        return this.repositoryMap;
    }

    @Override
    public Set<RequirementSource> getRequirementSources() {
        Collection<Set<RequirementSource>> values = this.repositoryMap.values();
        HashSet<RequirementSource> res = new HashSet<RequirementSource>();
        for (Set<RequirementSource> sources : values) {
            res.addAll(sources);
        }
        return res;
    }

    @Override
    public void notifyChange(String event, Object data) {
        this.broker.post(event, data);
    }

    @Override
    public RequirementSource createRequirementSource(String name, String connectorId) {
        RequirementSource source = this.createRequirementSource();
        source.setName(name);
        source.setConnectorId(connectorId);
        return source;
    }

    @Override
    public RequirementSource createRequirementSource() {
        RequirementSource source = RequirementSourceConfFactory.eINSTANCE.createRequirementSource();
        RequirementsContainer rc = RequirementSourceDataFactory.eINSTANCE.createRequirementsContainer();
        source.setContents(rc);
        return source;
    }

    @Override
    public Section createSection(String id, String name, String uri) {
        Section section = RequirementSourceDataFactory.eINSTANCE.createSection();
        section.setId(id);
        section.setText(name);
        section.setUri(uri);
        return section;
    }

    @Override
    public Trash createTrash(String id, String name, String uri) {
        Trash trash = RequirementSourceDataFactory.eINSTANCE.createTrash();
        trash.setId(id);
        trash.setText(name);
        trash.setUri(uri);
        return trash;
    }

    @Override
    public boolean addElementsToSection(Section section, AbstractElement ... element) {
        return section.getChildren().addAll(Arrays.asList(element));
    }

    @Override
    public boolean addElementsToSource(RequirementSource source, AbstractElement ... elements) {
        RequirementsContainer contents = source.getContents();
        if (contents == null) {
            contents = RequirementSourceDataFactory.eINSTANCE.createRequirementsContainer();
            source.setContents(contents);
        }
        return contents.getRequirements().addAll(Arrays.asList(elements));
    }

    @Override
    public boolean addElementsToRequirement(Requirement requirement, AbstractElement ... element) {
        return requirement.getChildren().addAll(Arrays.asList(element));
    }

    @Override
    public void addAttributeValue(AbstractElement element, IAttribute attribute, Object value) {
        EAttribute eFeature = (EAttribute)((IAdaptable)attribute).getAdapter(EStructuralFeature.class);
        if (eFeature.isMany()) {
            List l = (List)element.eGet((EStructuralFeature)eFeature);
            l.add(value);
        } else {
            element.eSet((EStructuralFeature)eFeature, value);
        }
    }

    @Override
    public void load() {
        for (RequirementSource requirementSource : this.sources.getRequirementSources()) {
            requirementSource = this.resolveProxy(requirementSource);
            this.loadContents(requirementSource.getRequirements());
        }
    }

    private void loadContents(EList<AbstractElement> requirements) {
        for (AbstractElement abstractElement : requirements) {
            if ((abstractElement = this.resolveProxy(abstractElement)) != null && abstractElement.getScopes() != null && !abstractElement.getScopes().isEmpty()) {
                for (Scope scope : abstractElement.getScopes()) {
                    scope = this.resolveProxy(scope);
                }
            }
            if (!(abstractElement instanceof Requirement)) continue;
            this.loadContents((EList<AbstractElement>)((Requirement)abstractElement).getChildren());
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        URI platform;
        ImmutableMap setSources;
        RequirementSource reqSource;
        IResource res = delta.getResource();
        if (res instanceof IFile && ((IFile)res).getFileExtension().equals("reqcycle") && (reqSource = (RequirementSource)(setSources = Maps.uniqueIndex(this.sources.getRequirementSources(), (Function)new Function<RequirementSource, URI>(){

            public URI apply(RequirementSource arg0) {
                return URI.createURI((String)arg0.getDestinationURI());
            }
        })).get(platform = URI.createPlatformResourceURI((String)res.getFullPath().toString(), (boolean)true))) != null) {
            try {
                Resource r = this.confManager.getConfigurationResourceSet().getResource(platform, false);
                if (r != null && r.isLoaded()) {
                    r.unload();
                    r.load(Collections.emptyMap());
                    ViewerNotification notification = new ViewerNotification((Notification)new NotificationImpl(1, r, r){

                        public Object getNotifier() {
                            return reqSource;
                        }
                    }, (Object)reqSource.getContents());
                    reqSource.eNotify((Notification)notification);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

