/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.configuration.preferences.providers;

import javax.inject.Inject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.ElementTypeConfigurationPage;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.CustomType;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Type;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.TypeConfigContainer;
import org.polarsys.reqcycle.types.ITypesManager;
import org.polarsys.reqcycle.types.ui.providers.TypeLabelProvider;

public class PreferenceDialogTypeLabelProvider
extends AdapterFactoryLabelProvider {
    @Inject
    private ITypesManager typesManager;
    private ILabelProvider original;
    private TypeLabelProvider forTypes;

    public PreferenceDialogTypeLabelProvider(AdapterFactory adapterFactory, ILabelProvider delegeated) {
        super(adapterFactory);
        this.original = delegeated;
        this.forTypes = new TypeLabelProvider();
    }

    public String getText(Object object) {
        String text = super.getText(object);
        if (object instanceof Type) {
            Type type = (Type)object;
            if (ElementTypeConfigurationPage.isExtensible(type, this.typesManager)) {
                text = String.valueOf(text) + " (can be specialized)";
            }
        } else if (object instanceof TypeConfigContainer) {
            text = "Types";
        }
        return text;
    }

    public Image getImage(Object element) {
        String typeId = null;
        if (element instanceof CustomType) {
            CustomType custom = (CustomType)element;
            typeId = custom.getSuperType().getTypeId();
        } else if (element instanceof Type) {
            Type type = (Type)element;
            typeId = type.getTypeId();
        }
        if (typeId != null) {
            return this.forTypes.getImage(this.typesManager.getType(typeId));
        }
        return this.original.getImage(element);
    }
}

