/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.engine;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.model.Filter;
import org.polarsys.reqcycle.traceability.model.StopCondition;
import org.polarsys.reqcycle.traceability.model.scopes.CompositeScope;
import org.polarsys.reqcycle.traceability.model.scopes.IScope;
import org.polarsys.reqcycle.traceability.model.scopes.ResourceScope;
import org.polarsys.reqcycle.traceability.utils.Conditions;
import org.polarsys.reqcycle.uri.model.Reachable;

public class Request {
    protected ITraceabilityEngine.DIRECTION direction = ITraceabilityEngine.DIRECTION.DOWNWARD;
    protected Map<String, Object> extraProperties = new HashMap<String, Object>();
    protected CompositeScope scope = new CompositeScope();
    protected Filter filter = null;
    private Set<Couple> elements = new HashSet<Couple>();
    private DEPTH depth = DEPTH.INFINITE;

    public Request setDepth(DEPTH depth) {
        this.depth = depth;
        return this;
    }

    public DEPTH getDepth() {
        return this.depth;
    }

    public Request setFilter(Filter f) {
        this.filter = f;
        return this;
    }

    public Request setScope(IScope s) {
        this.scope.add(s);
        return this;
    }

    public Request addSourceAndTarget(Reachable s, Reachable t) {
        if (t != null) {
            this.addSourceAndCondition(s, Conditions.reachableEquals(t));
        } else {
            this.addSourceAndCondition(s, null);
        }
        return this;
    }

    public Request addSourceAndCondition(Reachable s, StopCondition t) {
        Couple sourceTarget = new Couple(s, t);
        this.elements.add(sourceTarget);
        this.addScope(sourceTarget);
        return this;
    }

    private void addScope(Couple sourceTarget) {
        this.scope.add(sourceTarget.getScope());
    }

    public Request addSource(Reachable r) {
        this.addSourceAndTarget(r, null);
        return this;
    }

    public Request setDirection(ITraceabilityEngine.DIRECTION d) {
        this.direction = d;
        return this;
    }

    public ITraceabilityEngine.DIRECTION getDirection() {
        return this.direction;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Iterable<Couple> getCouples() {
        return Iterables.unmodifiableIterable(this.elements);
    }

    public IScope getScope() {
        return this.scope;
    }

    public Request addProperty(String key, Object value) {
        this.extraProperties.put(key, value);
        return this;
    }

    public Object getProperty(String key) {
        return this.extraProperties.get(key);
    }

    public static class Couple {
        private Reachable s;
        private StopCondition t;

        public Couple(Reachable s, StopCondition t) {
            this.s = s;
            this.t = t;
        }

        public IScope getScope() {
            CompositeScope scope = new CompositeScope();
            if (this.s != null) {
                scope.add(new ResourceScope(this.s));
            }
            if (this.t instanceof StopCondition.ScopedStopCondition) {
                scope.add(((StopCondition.ScopedStopCondition)this.t).getScope());
            }
            return scope;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.s == null ? 0 : this.s.hashCode());
            result = 31 * result + (this.t == null ? 0 : this.t.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Couple other = (Couple)obj;
            if (this.s == null ? other.s != null : !this.s.equals((Object)other.s)) {
                return false;
            }
            return !(this.t == null ? other.t != null : !this.t.equals(other.t));
        }

        public Reachable getSource() {
            return this.s;
        }

        public StopCondition getStopCondition() {
            return this.t;
        }
    }

    public static enum DEPTH {
        ONE,
        INFINITE;

    }
}

