/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.sesame.storage;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.inject.Singleton;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;
import org.openrdf.sail.nativerdf.NativeStore;

@Singleton
public class SesameRepositoryHolder {
    private static final String REPOSITORY_FOLDER = "/binary";
    private LoadingCache<String, Repository> repositories = CacheBuilder.newBuilder().build((CacheLoader)new InitRepositoryCallable());
    private LoadingCache<String, ThreadLocal<RepositoryConnection>> connections = CacheBuilder.newBuilder().build((CacheLoader)new ThreadLocalConnectionsBuilderCallable());

    public Repository getRepository(String path) throws ExecutionException {
        return (Repository)this.repositories.get((Object)path);
    }

    public RepositoryConnection getConnection(String path) throws RepositoryException, ExecutionException {
        ThreadLocal connectionsThreadLocal = (ThreadLocal)this.connections.get((Object)path);
        RepositoryConnection connection = (RepositoryConnection)connectionsThreadLocal.get();
        if (connection == null || !connection.isOpen()) {
            Repository repository = this.getRepository(path);
            connection = repository.getConnection();
            connectionsThreadLocal.set(connection);
        }
        return connection;
    }

    private static final class InitRepositoryCallable
    extends CacheLoader<String, Repository> {
        private InitRepositoryCallable() {
        }

        public Repository load(String path) throws RepositoryException {
            NativeStore store = new NativeStore(new File(String.valueOf(path) + SesameRepositoryHolder.REPOSITORY_FOLDER));
            SailRepository repository = new SailRepository((Sail)store);
            repository.initialize();
            return repository;
        }
    }

    private static final class ThreadLocalConnectionsBuilderCallable
    extends CacheLoader<String, ThreadLocal<RepositoryConnection>> {
        private ThreadLocalConnectionsBuilderCallable() {
        }

        public ThreadLocal<RepositoryConnection> load(String path) {
            return new ThreadLocal<RepositoryConnection>();
        }
    }
}

