/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.ui.presentation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceSetItemProvider;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.predicates.core.util.PredicatesResourceImpl;
import org.polarsys.reqcycle.predicates.persistance.util.IPredicatesConfManager;
import org.polarsys.reqcycle.predicates.ui.PredicatesUIPlugin;
import org.polarsys.reqcycle.predicates.ui.components.PredicatesTreeViewer;
import org.polarsys.reqcycle.predicates.ui.components.RightPanelComposite;
import org.polarsys.reqcycle.predicates.ui.components.RuntimeRegisteredPackageDialog;
import org.polarsys.reqcycle.predicates.ui.listeners.CustomPredicatesTreeViewerDragAdapter;
import org.polarsys.reqcycle.predicates.ui.listeners.PredicatesTreeDoubleClickListener;
import org.polarsys.reqcycle.predicates.ui.listeners.PredicatesTreeViewerDropAdapter;
import org.polarsys.reqcycle.predicates.ui.providers.EnhancedPredicatesTreeLabelProvider;
import org.polarsys.reqcycle.predicates.ui.providers.PredicatesItemProviderAdapterFactory;
import org.polarsys.reqcycle.predicates.ui.util.PredicatesUIHelper;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class PredicatesEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker,
IPropertyChangeListener {
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected List<PropertySheetPage> propertySheetPages = new ArrayList<PropertySheetPage>();
    protected PredicatesTreeViewer selectionViewer;
    protected TreeViewer parentViewer;
    protected TreeViewer treeViewer;
    protected ListViewer listViewer;
    protected TableViewer tableViewer;
    protected TreeViewer treeViewerWithColumns;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    public static final String ID = "org.polarsys.reqcycle.predicates.ui.presentation.PredicatesEditorID";
    private boolean dirty;
    private Collection<EClass> input;
    private PredicatesTreeDoubleClickListener treeDoubleClickListener;
    private RightPanelComposite rightPanel;
    private Resource resource;
    IPredicatesConfManager predicateManager = (IPredicatesConfManager)ZigguratInject.make(IPredicatesConfManager.class);
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == PredicatesEditor.this.contentOutlinePage) {
                    PredicatesEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)PredicatesEditor.this);
                    PredicatesEditor.this.setCurrentViewer((Viewer)PredicatesEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (PredicatesEditor.this.propertySheetPages.contains(((PropertySheet)p).getCurrentPage())) {
                    PredicatesEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)PredicatesEditor.this);
                    PredicatesEditor.this.handleActivate();
                }
            } else if (p == PredicatesEditor.this) {
                PredicatesEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = PredicatesEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            PredicatesEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            PredicatesEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!PredicatesEditor.this.updateProblemIndication) return;
                        PredicatesEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PredicatesEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
            PredicatesEditor.this.resourceToDiagnosticMap.remove(target);
            if (PredicatesEditor.this.updateProblemIndication) {
                PredicatesEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PredicatesEditor.this.updateProblemIndication();
                    }
                });
            }
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).PredicatesEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1) {
                            Resource resource;
                            if ((delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                                if (delta.getKind() == 2) {
                                    this.removedResources.add(resource);
                                } else if (!(this).PredicatesEditor.this.savedResources.remove(resource)) {
                                    this.changedResources.add(resource);
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    PredicatesEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).PredicatesEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!PredicatesEditor.this.isDirty()) {
                                PredicatesEditor.this.getSite().getPage().closeEditor((IEditorPart)PredicatesEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    PredicatesEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).PredicatesEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (PredicatesEditor.this.getSite().getPage().getActiveEditor() == PredicatesEditor.this) {
                                PredicatesEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                PredicatesUIPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    private ViewerPane viewerPane;

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.polarsys.reqcycle.predicates.ui", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    PredicatesUIPlugin.INSTANCE.log((Object)exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        PredicatesUIPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)PredicatesEditor.getString("_UI_FileConflict_label"), (String)PredicatesEditor.getString("_WARN_FileConflict"));
    }

    public PredicatesEditor() {
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory(){

            public Adapter createResourceSetAdapter() {
                return new ResourceSetItemProvider((AdapterFactory)this){

                    public Collection<?> getChildren(Object object) {
                        ArrayList result = new ArrayList();
                        for (Object child : super.getChildren(object)) {
                            if (!(child instanceof PredicatesResourceImpl)) continue;
                            result.addAll(((PredicatesResourceImpl)child).getContents());
                        }
                        return result;
                    }
                };
            }
        });
        this.adapterFactory.addAdapterFactory((AdapterFactory)new PredicatesItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                PredicatesEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PredicatesEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            PredicatesEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        Iterator<PropertySheetPage> i = (this).PredicatesEditor.this.propertySheetPages.iterator();
                        while (i.hasNext()) {
                            PropertySheetPage propertySheetPage = i.next();
                            if (propertySheetPage.getControl().isDisposed()) {
                                i.remove();
                                continue;
                            }
                            propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (PredicatesEditor.this.currentViewer != null) {
                        PredicatesEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
        }
        this.setCurrentViewer(this.currentViewerPane.getViewer());
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        PredicatesEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new CustomPredicatesTreeViewerDragAdapter((Viewer)viewer){});
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new PredicatesTreeViewerDropAdapter((EditingDomain)this.editingDomain, viewer));
    }

    public void createModel() {
        Exception exception = null;
        try {
            this.initResource();
        }
        catch (Exception e) {
            exception = e;
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(this.resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(this.resource, this.analyzeResourceProblems(this.resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.polarsys.reqcycle.predicates.ui", 0, PredicatesEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.polarsys.reqcycle.predicates.ui", 0, PredicatesEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public void createPages() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            this.getContainer().setLayout((Layout)new GridLayout());
            this.viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

                public Viewer createViewer(Composite composite) {
                    composite.setLayout((Layout)new GridLayout());
                    Tree tree = new Tree(composite, 2);
                    PredicatesTreeViewer predicatesTreeViewer = new PredicatesTreeViewer(tree);
                    return predicatesTreeViewer;
                }

                public void requestActivation() {
                    super.requestActivation();
                    PredicatesEditor.this.setCurrentViewerPane(this);
                }
            };
            this.viewerPane.createControl(this.getContainer());
            EnhancedPredicatesTreeLabelProvider predicatesLabelProvider = new EnhancedPredicatesTreeLabelProvider((AdapterFactory)this.adapterFactory);
            this.selectionViewer = (PredicatesTreeViewer)this.viewerPane.getViewer();
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)predicatesLabelProvider);
            this.selectionViewer.setInput(this.editingDomain.getResourceSet());
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.treeDoubleClickListener = new PredicatesTreeDoubleClickListener(this, this.getInput(), false);
            this.selectionViewer.addDoubleClickListener(this.treeDoubleClickListener);
            this.getSite().setSelectionProvider((ISelectionProvider)this.selectionViewer);
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage(this.viewerPane.getControl());
            this.setPageText(pageIndex, PredicatesEditor.getString("_UI_SelectionPage_label"));
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PredicatesEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    PredicatesEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                PredicatesEditor.this.updateProblemIndication();
            }
        });
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, PredicatesEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    PredicatesEditor.this.contentOutlineViewer = this.getTreeViewer();
                    PredicatesEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    PredicatesEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)PredicatesEditor.this.adapterFactory));
                    PredicatesEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.ColorProvider((AdapterFactory)PredicatesEditor.this.adapterFactory, (Viewer)PredicatesEditor.this.contentOutlineViewer));
                    PredicatesEditor.this.contentOutlineViewer.setInput((Object)PredicatesEditor.this.editingDomain.getResourceSet());
                    PredicatesEditor.this.createContextMenuFor((StructuredViewer)PredicatesEditor.this.contentOutlineViewer);
                    if (!PredicatesEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        PredicatesEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(PredicatesEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    PredicatesEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    PredicatesEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    PredicatesEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        ExtendedPropertySheetPage propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

            public void setSelectionToViewer(List<?> selection) {
                PredicatesEditor.this.setSelectionToViewer(selection);
                PredicatesEditor.this.setFocus();
            }

            public void setActionBars(IActionBars actionBars) {
                super.setActionBars(actionBars);
                PredicatesEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
            }
        };
        propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.propertySheetPages.add((PropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.currentViewerPane != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            if (this.currentViewerPane.getViewer() == this.selectionViewer) {
                ArrayList selectionList = new ArrayList();
                selectionList.add(selectedElement);
                while (selectedElements.hasNext()) {
                    selectionList.add(selectedElements.next());
                }
                this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
            } else if (this.currentViewerPane.getViewer().getInput() != selectedElement) {
                this.currentViewerPane.getViewer().setInput(selectedElement);
                this.currentViewerPane.setTitle(selectedElement);
            }
        }
    }

    public boolean isDirty() {
        return this.dirty || ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.firePropertyChange(257);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        if (this.resource == null || this.resource.getContents() == null || this.resource.getContents().isEmpty()) {
            return;
        }
        EObject obj = (EObject)this.resource.getContents().get(0);
        if (obj instanceof IPredicate) {
            IPredicate newPredicate = (IPredicate)obj;
            String displayName = newPredicate.getDisplayName();
            if (displayName != null && !displayName.isEmpty()) {
                IPredicate p = this.predicateManager.getPredicateByName(displayName);
                if (p != null) {
                    this.predicateManager.removePredicate(p);
                    this.predicateManager.storePredicate(newPredicate);
                } else {
                    this.predicateManager.storePredicate(newPredicate);
                }
                this.editingDomain.getCommandStack().flush();
                this.setDirty(false);
            } else if (this.rightPanel != null) {
                this.savePredicate();
            }
        }
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName("Predicates Editor");
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void gotoMarker(IMarker marker) {
        List targetObjects = this.markerHelper.getTargetObjects((Object)this.editingDomain, marker);
        if (!targetObjects.isEmpty()) {
            this.setSelectionToViewer(targetObjects);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName("Predicates Editor");
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void setFocus() {
        if (this.currentViewerPane != null) {
            this.currentViewerPane.setFocus();
        } else {
            this.getControl(this.getActivePage()).setFocus();
        }
        PredicatesTreeViewer p = this.getPredicatesTreeViewer();
        if (p != null) {
            p.refresh();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(PredicatesEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(PredicatesEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(PredicatesEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return PredicatesUIPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return PredicatesUIPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        this.selectionViewer.removeDoubleClickListener(this.treeDoubleClickListener);
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        for (PropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    protected boolean showOutlineView() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.selectionViewer.refresh();
    }

    protected Composite createPageContainer(Composite parent) {
        SashForm sashForm = new SashForm(parent, 0);
        sashForm.setLayout((Layout)new GridLayout(2, false));
        Composite leftComposite = new Composite((Composite)sashForm, 2048);
        leftComposite.setLayout((Layout)new GridLayout(1, false));
        leftComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite editorComposite = new Composite(leftComposite, 2048);
        editorComposite.setLayout((Layout)new GridLayout());
        editorComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite btnComposite = new Composite(leftComposite, 2048);
        btnComposite.setLayout((Layout)new GridLayout());
        btnComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createParametersSection(btnComposite);
        this.createRightPanel((Composite)sashForm);
        return editorComposite;
    }

    private void createParametersSection(Composite btnComposite) {
        Section section = new Section(btnComposite, 2082);
        section.setText("Parameters");
        Composite compositeButtons = new Composite((Composite)section, 0);
        section.setClient((Control)compositeButtons);
        compositeButtons.setToolTipText("Whether or not to expand the model by showing all references and features.");
        compositeButtons.setLayout((Layout)new GridLayout(1, false));
        compositeButtons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        Button btnLoadResources = new Button(compositeButtons, 0);
        btnLoadResources.setText("Load Model");
        btnLoadResources.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeRegisteredPackageDialog registeredPackageDialog = new RuntimeRegisteredPackageDialog(PredicatesEditor.this.getSite().getShell());
                registeredPackageDialog.open();
                Object[] result = registeredPackageDialog.getResult();
                if (result != null) {
                    ArrayList<EClass> eclasses = new ArrayList<EClass>();
                    Object[] objectArray = result;
                    int n = result.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        Object obj = EPackage.Registry.INSTANCE.get(object);
                        if (obj instanceof EPackage) {
                            Collection<EClass> classes = PredicatesEditor.this.getAllEClasses((EPackage)obj);
                            eclasses.addAll(classes);
                        } else if (obj instanceof EPackage.Descriptor) {
                            EPackage.Descriptor desc = (EPackage.Descriptor)obj;
                            eclasses.addAll(PredicatesEditor.this.getAllEClasses(desc.getEPackage()));
                        }
                        ++n2;
                    }
                    PredicatesEditor.this.setInput(eclasses);
                }
            }
        });
        final Button expandCustomPredicatesButton = new Button(compositeButtons, 32);
        expandCustomPredicatesButton.setText("Allow expand of custom predicates");
        expandCustomPredicatesButton.setToolTipText("Show or hide custom predicates contents from the tree viewer.");
        expandCustomPredicatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PredicatesTreeViewer predicatesTreeViewer = PredicatesEditor.this.getPredicatesTreeViewer();
                boolean mayExpandCustomPredicates = expandCustomPredicatesButton.getSelection();
                predicatesTreeViewer.setMayExpandCustomPredicates(mayExpandCustomPredicates);
                if (!mayExpandCustomPredicates) {
                    Object[] expandedElements;
                    Object[] objectArray = expandedElements = predicatesTreeViewer.getExpandedElements();
                    int n = expandedElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object expandedElement = objectArray[n2];
                        if (expandedElement instanceof IPredicate && ((IPredicate)expandedElement).getDisplayName() != null) {
                            predicatesTreeViewer.collapseToLevel(expandedElement, -1);
                        }
                        ++n2;
                    }
                }
                predicatesTreeViewer.refresh();
            }
        });
        expandCustomPredicatesButton.setSelection(false);
    }

    protected Collection<EClass> getAllEClasses(EPackage obj) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        for (EClassifier eClassifier : obj.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            result.add((EClass)eClassifier);
        }
        for (EPackage ePackage : obj.getESubpackages()) {
            result.addAll(this.getAllEClasses(ePackage));
        }
        return result;
    }

    private void createRightPanel(Composite newParent) {
        SashForm rightComposite = new SashForm(newParent, 2048);
        rightComposite.setLayout((Layout)new GridLayout(1, false));
        rightComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.rightPanel = new RightPanelComposite((Composite)rightComposite, this);
        this.rightPanel.setLayoutData(new GridData(4, 4, true, true, 1, 1));
    }

    public Collection<EClass> getInput() {
        return this.input;
    }

    public void setInput(Object input) {
        if (this.input == null) {
            this.input = new ArrayList<EClass>();
        }
        if (input instanceof EClass) {
            this.input.add((EClass)input);
        } else if (input instanceof Collection) {
            this.input.addAll((Collection)input);
        } else if (input instanceof EClass[]) {
            this.input.addAll(Arrays.asList(input));
        } else {
            throw new IllegalArgumentException("Not supported type of input.");
        }
        this.treeDoubleClickListener.setEClasses(this.getInput());
    }

    public IPredicate getEditedPredicate() {
        return (IPredicate)this.resource.getContents().get(0);
    }

    private void initResource() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        this.resource = this.editingDomain.getResourceSet().createResource(resourceURI);
    }

    public boolean setRootPredicate(IPredicate rootPredicate) {
        Viewer viewer;
        if (this.resource == null) {
            this.initResource();
        }
        if (this.isDirty()) {
            if (!MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Unsaved Changes", (String)"There is unsaved changes. Continue and discard them")) {
                return false;
            }
            this.editingDomain.getCommandStack().flush();
        }
        if (!this.resource.getContents().isEmpty()) {
            this.resource.getContents().clear();
        }
        if (rootPredicate != null) {
            this.resource.getContents().add((Object)rootPredicate);
        }
        if ((viewer = this.getViewer()) != null) {
            viewer.refresh();
        }
        this.setDirty(false);
        return true;
    }

    public void setUseExtendedFeature(boolean useExtendedFeature) {
        this.treeDoubleClickListener.setUseExtendedFeature(useExtendedFeature);
    }

    public PredicatesTreeViewer getPredicatesTreeViewer() {
        return this.selectionViewer;
    }

    public void setEditorTitle(String title) {
        if (this.viewerPane != null && title != null) {
            this.viewerPane.setTitle(title, title != null && !title.isEmpty() ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.reqcycle.predicates.ui", (String)"/icons/full/obj16/PredicatesEditorIcon_16.png").createImage() : null);
        }
    }

    public void savePredicate() {
        String result = PredicatesUIHelper.openInputDialog(this.getSite().getShell());
        if (result != null) {
            IPredicate predicate = this.getEditedPredicate();
            this.setEditorTitle(result);
            this.setDirty(false);
            predicate.setDisplayName(result);
            IPredicate newPredicate = (IPredicate)EcoreUtil.copy((EObject)predicate);
            boolean added = this.predicateManager.storePredicate(newPredicate);
            if (added && this.rightPanel != null) {
                this.rightPanel.addPredicate(newPredicate);
            } else if (!added) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error adding predicate", (String)("Unable to add the predicate : " + newPredicate.getDisplayName()));
            }
        }
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }
}

