/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.ui.dialogs;

import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.reqcycle.core.ui.dialogs.ValidatingTitleAreaDialog;
import org.polarsys.reqcycle.operations.ReqCycleOperation;
import org.polarsys.reqcycle.operations.dialogs.OperationAttributesEditor;
import org.polarsys.reqcycle.operations.dialogs.SelectOperationDialog;
import org.polarsys.reqcycle.predicates.core.api.OperationPredicate;
import org.polarsys.reqcycle.ui.eattrpropseditor.GenericEAttrPropsEditor;

public class OperationDialog
extends ValidatingTitleAreaDialog {
    private OperationPredicate predicate;
    private Text operationText;
    private Button btnSelectOperation;
    private Button btnEditOperation;
    private Method method;
    private Map<String, GenericEAttrPropsEditor> editors;
    private String operationName;

    public OperationDialog(OperationPredicate predicate, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(1184);
        this.predicate = predicate;
        this.operationName = null;
        this.editors = null;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.validateInput();
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Edit Operation Predicate : " + this.predicate.getDisplayName());
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        area.setLayout((Layout)new GridLayout(3, false));
        this.operationText = new Text(area, 2048);
        this.operationText.setEditable(false);
        this.operationText.setEnabled(false);
        this.operationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnSelectOperation = new Button(area, 0);
        this.btnSelectOperation.setText("...");
        this.btnSelectOperation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectOperationDialog dialog = new SelectOperationDialog(Display.getDefault().getActiveShell());
                int result = dialog.open();
                if (result == 0) {
                    ReqCycleOperation op = dialog.getResult();
                    String opText = op.getMethod().getName();
                    OperationDialog.this.method = op.getMethod();
                    Class<?>[] paramList = OperationDialog.this.method.getParameterTypes();
                    if (paramList.length > 1) {
                        opText = String.valueOf(opText) + "(";
                        int i = 1;
                        while (i < paramList.length) {
                            Class<?> c = paramList[i];
                            if (i != 1) {
                                opText = String.valueOf(opText) + " ,";
                            }
                            opText = String.valueOf(opText) + c.getSimpleName();
                            ++i;
                        }
                        opText = String.valueOf(opText) + ")";
                    }
                    OperationDialog.this.operationText.setText(opText);
                    if (OperationDialog.this.method.getParameterTypes().length > 1) {
                        OperationDialog.this.btnEditOperation.setEnabled(true);
                    } else {
                        OperationDialog.this.btnEditOperation.setEnabled(false);
                    }
                    OperationDialog.this.operationName = op.getMethod().getName();
                    OperationDialog.this.validateInput();
                }
            }
        });
        this.btnEditOperation = new Button(area, 0);
        this.btnEditOperation.setText("Edit");
        this.btnEditOperation.setEnabled(false);
        new Label(area, 0);
        new Label(area, 0);
        new Label(area, 0);
        this.btnEditOperation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OperationAttributesEditor dialog = new OperationAttributesEditor(Display.getDefault().getActiveShell(), OperationDialog.this.method);
                int result = dialog.open();
                if (result == 0) {
                    OperationDialog.this.editors = dialog.getEditors();
                }
                OperationDialog.this.validateInput();
            }
        });
        return area;
    }

    public ValidatingTitleAreaDialog.IValidator getInputValidator() {
        return new ValidatingTitleAreaDialog.IValidator(){

            public String isValid() {
                if (OperationDialog.this.operationName == null) {
                    return "An operation must be selected";
                }
                return null;
            }
        };
    }

    public Map<String, GenericEAttrPropsEditor> getEditors() {
        return this.editors;
    }

    public String getOperationName() {
        return this.operationName;
    }
}

