/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.iterators.factories;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import org.polarsys.reqcycle.utils.iterators.collectors.ArcHarvester;
import org.polarsys.reqcycle.utils.iterators.collectors.DepthHarvester;
import org.polarsys.reqcycle.utils.iterators.collectors.IHarvester;
import org.polarsys.reqcycle.utils.iterators.collectors.WidthHarvester;
import org.polarsys.reqcycle.utils.iterators.pickers.IArc;
import org.polarsys.reqcycle.utils.iterators.pickers.IPicker;
import org.polarsys.reqcycle.utils.iterators.utils.YieldAdapterIterable;
import org.polarsys.reqcycle.utils.iterators.yieldadapters.RedundancyAwareThreadedYieldAdapter;
import org.polarsys.reqcycle.utils.iterators.yieldadapters.ThreadedYieldAdapter;
import org.polarsys.reqcycle.utils.iterators.yieldadapters.YieldAdapter;

public class IteratorFactory {
    protected Iterable<IPicker> pickers;
    protected IHarvester harvester;
    protected YieldAdapter<Object> yieldAdapter;

    public IteratorFactory(Iterable<IPicker> pickers) {
        this(pickers, new DepthHarvester(null));
    }

    public IteratorFactory(Iterable<IPicker> pickers, IHarvester harvester) {
        this.pickers = pickers;
        this.harvester = harvester;
        this.harvester.setPickers(pickers);
        this.yieldAdapter = new ThreadedYieldAdapter<Object>();
    }

    public Iterable<Object> createIterable(Object element) {
        this.harvester.setStartingElement(element);
        return this.yieldAdapter.adapt(this.harvester);
    }

    public void activateWidthWisdom() {
        this.harvester = new WidthHarvester(null);
        this.harvester.setPickers(this.pickers);
    }

    public void activateDepthWisdom() {
        this.harvester = new DepthHarvester(null);
        this.harvester.setPickers(this.pickers);
    }

    public void activateRedundancyAwareness() {
        this.yieldAdapter = new RedundancyAwareThreadedYieldAdapter<Object>();
    }

    public void deactivateRedundancyAwareness() {
        this.yieldAdapter = new ThreadedYieldAdapter<Object>();
    }

    public Iterable<Object> createTransitionWiseIterable(Object startingElement) {
        ArcHarvester arcHarvester = new ArcHarvester(this.harvester, this.pickers);
        arcHarvester.setStartingElement(startingElement);
        YieldAdapterIterable<Object> arcIterable = this.yieldAdapter.adapt(arcHarvester);
        return Iterables.transform(arcIterable, (Function)new Function<Object, Object>(){

            public Object apply(Object from) {
                if (from instanceof IArc) {
                    return ((IArc)from).getDestination();
                }
                return from;
            }
        });
    }
}

