/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.core.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.reqcycle.core.ILogger;
import org.polarsys.reqcycle.utils.configuration.Activator;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class InitializeConfigurationHandler
extends AbstractHandler {
    protected String reqCyclePrefix = "org.polarsys.reqcycle";
    ILogger logger = (ILogger)ZigguratInject.make(ILogger.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.initializeConf();
        return null;
    }

    protected void initializeConf() {
        boolean msg = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"ReqCycle initialization", (String)"- All current ReqCycle Data will be lost \n- The platform have to be restarted after this initialization.\n\nWould you continue?");
        if (!msg) {
            return;
        }
        IPath confFilePath = Activator.getDefault().getStateLocation();
        URI folderURI = URI.createURI((String)confFilePath.toOSString());
        this.cleanFolder(folderURI, this.reqCyclePrefix);
        byte[] buffer = new byte[1024];
        try {
            FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
            String uri = dialog.open();
            if (uri != null) {
                File f = new File(uri);
                FileInputStream fileInputStream = new FileInputStream(f);
                ZipInputStream inputStream = new ZipInputStream(fileInputStream);
                ZipEntry entry = inputStream.getNextEntry();
                while (entry != null) {
                    int len;
                    String fileName = entry.getName();
                    File newFile = new File(Activator.getDefault().getStateLocation() + File.separator + fileName);
                    if (newFile.getParent() != null) {
                        new File(newFile.getParent()).mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = inputStream.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                    entry = inputStream.getNextEntry();
                }
                inputStream.close();
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"ReqCycle Initialization", (String)"Please restart the platform for changes to take effect.");
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    protected void cleanFolder(URI folderURI, String namePrefix) {
        File[] listOfFiles;
        File folder = new File(folderURI.toString());
        File[] fileArray = listOfFiles = folder.listFiles();
        int n = listOfFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && file.getName().startsWith(namePrefix)) {
                String msg = "file " + file.getName() + " has been deleted";
                if (file.delete()) {
                    this.logger.trace(msg);
                }
            }
            ++n2;
        }
    }
}

