/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.ui.eattrpropseditor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.polarsys.reqcycle.ui.eattrpropseditor.api.IEAttrPropsEditor;

public class EAttrPropsEditorPlugin
implements BundleActivator {
    public static final String PLUGIN_ID = "org.polarsys.reqcycle.ui.eattrpropseditor";
    private static BundleContext context;
    private static Map<Class<?>, Instantiator> eAttrEditorManager;

    static {
        eAttrEditorManager = new HashMap();
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.readEAttrEditorExtensions();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }

    private void readEAttrEditorExtensions() {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(PLUGIN_ID, "definition");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Class type = Platform.getBundle((String)e.getContributor().getName()).loadClass(e.getAttribute("type"));
                eAttrEditorManager.put(type, new Instantiator(e));
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (InvalidRegistryObjectException e1) {
                e1.printStackTrace();
            }
            ++n2;
        }
        eAttrEditorManager = Collections.unmodifiableMap(eAttrEditorManager);
    }

    public static Map<Class<?>, Instantiator> getEAttrEditorManager() {
        return eAttrEditorManager;
    }

    public static IEAttrPropsEditor<?> getStructuralFeatureEditor(String attributeName, Class type, Composite container, int style) {
        IEAttrPropsEditor<?> editor = EAttrPropsEditorPlugin.getEditorByTypeInstance(type);
        if (editor != null) {
            editor.setContainer(container);
            editor.setStyle(style);
            editor.setAttributeName(attributeName);
            return editor;
        }
        throw new UnsupportedOperationException("Unsupported type. No editor found ...");
    }

    public static String getEditorType(EClassifier eType) {
        if (eType instanceof EClass) {
            throw new UnsupportedOperationException("EClass not yet supported ...");
        }
        String editorType = eType.getInstanceClassName();
        if (eType instanceof EEnum) {
            editorType = EEnum.class.getName();
        } else {
            try {
                Class javaClass = ClassUtils.getClass((String)editorType);
                if (javaClass.isPrimitive()) {
                    javaClass = ClassUtils.primitiveToWrapper((Class)javaClass);
                }
                editorType = javaClass.getName();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace(System.err);
                return null;
            }
        }
        return editorType;
    }

    private static IEAttrPropsEditor<?> getEditorByTypeInstance(Class<?> initialClass) {
        try {
            Class<?> nearestClass = null;
            for (Class<?> currentSupportedClass : EAttrPropsEditorPlugin.getEAttrEditorManager().keySet()) {
                if (!currentSupportedClass.isAssignableFrom(initialClass)) continue;
                if (nearestClass == null || nearestClass.isAssignableFrom(currentSupportedClass)) {
                    nearestClass = currentSupportedClass;
                }
                if (nearestClass.equals(initialClass)) break;
            }
            if (nearestClass != null) {
                return EAttrPropsEditorPlugin.getEAttrEditorManager().get(nearestClass).create();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    public static class Instantiator {
        private IConfigurationElement element;

        public Instantiator(IConfigurationElement element) {
            this.element = element;
        }

        public IEAttrPropsEditor<?> create() {
            try {
                return (IEAttrPropsEditor)this.element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

