/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.provisional.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.ui.internal.contentassist.ProposalComparator;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.core.model.StylesheetModel;
import org.eclipse.wst.xsl.ui.provisional.contentassist.IContentAssistProposalRequest;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXSLContentAssistRequest
implements IContentAssistProposalRequest {
    protected IStructuredDocumentRegion documentRegion = null;
    protected ArrayList<ICompletionProposal> macros = new ArrayList();
    protected String matchString;
    protected Node node = null;
    protected ArrayList<ICompletionProposal> proposals = new ArrayList();
    protected ITextRegion region = null;
    protected int replacementBeginPosition;
    protected int replacementLength;
    protected ITextViewer textViewer = null;

    public AbstractXSLContentAssistRequest(Node node, IStructuredDocumentRegion documentRegion, ITextRegion completionRegion, int begin, int length, String filter, ITextViewer textViewer) {
        this.setNode(node);
        this.setDocumentRegion(documentRegion);
        this.setRegion(completionRegion);
        this.setMatchString(filter);
        this.setReplacementBeginPosition(begin);
        this.setReplacementLength(length);
        this.textViewer = textViewer;
    }

    @Override
    public abstract ArrayList<ICompletionProposal> getCompletionProposals();

    protected ArrayList<ICompletionProposal> getAllCompletionProposals() {
        ArrayList<ICompletionProposal> allProposals = new ArrayList<ICompletionProposal>();
        if (this.getProposals().size() > 0 || this.getMacros().size() > 0) {
            allProposals.addAll(this.getProposals());
            allProposals.addAll(this.getMacros());
            allProposals = this.sortProposals(allProposals);
        }
        return allProposals;
    }

    protected boolean hasNodes(NodeList nodes) {
        return nodes != null && nodes.getLength() > 0;
    }

    protected int getCursorPosition() {
        return this.textViewer.getTextWidget().getCaretOffset();
    }

    protected Collection<NamespaceInfo> getNamespaces(IDOMElement element) {
        NamespaceTable table = new NamespaceTable(element.getOwnerDocument());
        table.visitElement((Element)element);
        Collection namespaceInfoList = table.getNamespaceInfoCollection();
        return namespaceInfoList;
    }

    protected String getLocation() {
        IDOMDocument document = (IDOMDocument)this.node.getOwnerDocument();
        return document.getModel().getBaseLocation();
    }

    protected void addMacro(ICompletionProposal newProposal) {
        this.macros.add(newProposal);
    }

    protected void addProposal(ICompletionProposal newProposal) {
        this.proposals.add(newProposal);
    }

    protected IStructuredDocumentRegion getDocumentRegion() {
        return this.documentRegion;
    }

    protected List<ICompletionProposal> getMacros() {
        return this.macros;
    }

    protected String getMatchString() {
        return this.matchString;
    }

    protected Node getNode() {
        return this.node;
    }

    protected Node getParent() {
        return this.node.getParentNode();
    }

    protected List<ICompletionProposal> getProposals() {
        return this.proposals;
    }

    protected ITextRegion getRegion() {
        return this.region;
    }

    protected int getReplacementBeginPosition() {
        return this.replacementBeginPosition;
    }

    protected int getReplacementLength() {
        return this.replacementLength;
    }

    protected int getStartOffset() {
        if (this.getDocumentRegion() != null && this.getRegion() != null) {
            return this.getDocumentRegion().getStartOffset(this.getRegion());
        }
        return -1;
    }

    protected String getText() {
        if (this.getDocumentRegion() != null && this.getRegion() != null) {
            return this.getDocumentRegion().getText(this.getRegion());
        }
        return "";
    }

    protected int getTextEndOffset() {
        if (this.getDocumentRegion() != null && this.getRegion() != null) {
            return this.getDocumentRegion().getTextEndOffset(this.getRegion());
        }
        return -1;
    }

    protected void setDocumentRegion(IStructuredDocumentRegion region) {
        this.documentRegion = region;
    }

    protected void setMatchString(String newMatchString) {
        this.matchString = newMatchString;
    }

    protected void setNode(Node newNode) {
        this.node = newNode;
    }

    protected void setRegion(ITextRegion newRegion) {
        this.region = newRegion;
    }

    protected void setReplacementBeginPosition(int newReplacementBeginPosition) {
        this.replacementBeginPosition = newReplacementBeginPosition;
    }

    protected void setReplacementLength(int newReplacementLength) {
        this.replacementLength = newReplacementLength;
    }

    protected ArrayList<ICompletionProposal> sortProposals(ArrayList<ICompletionProposal> proposalsIn) {
        Collections.sort(proposalsIn, new ProposalComparator());
        return proposalsIn;
    }

    public String toString() {
        return "Node: " + this.getNode() + "\nParent: " + this.getParent() + "\nStructuredDocumentRegion: " + StringUtils.escape((String)this.getDocumentRegion().toString()) + "\nRegion: " + this.getRegion() + "\nMatch string: '" + StringUtils.escape((String)this.getMatchString()) + "'" + "\nOffsets: [" + this.getReplacementBeginPosition() + "-" + (this.getReplacementBeginPosition() + this.getReplacementLength()) + "]\n";
    }

    protected StylesheetModel getStylesheetModel() {
        IFile editorFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getLocation()));
        StylesheetModel model = XSLCore.getInstance().getStylesheet(editorFile);
        return model;
    }
}

