/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.internal.facet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.web.internal.WSTWebPlugin;
import org.eclipse.wst.web.internal.facet.MappingDescriptor;

public class RuntimePresetMappingRegistry {
    static final String EXTENSION_POINT = "runtimePresetMappings";
    static final String ELEMENT_MAPPING = "mapping";
    static final String ATTRIBUTE_ID = "id";
    static final String ATTRIBUTE_FACET_RUNTIME_TYPE_ID = "facetRuntimeTypeID";
    static final String ATTRIBUTE_FACET_RUNTIME_VERSION = "facetRuntimeVersion";
    static final String ATTRIBUTE_FACET_ID = "facetID";
    static final String ATTRIBUTE_FACET_VERSION = "facetVersion";
    static final String ATTRIBUTE_PRESET_ID = "presetID";
    public static RuntimePresetMappingRegistry INSTANCE = new RuntimePresetMappingRegistry();
    private List<MappingDescriptor> descriptors = null;

    public String getPresetID(String facetRuntimeTypeID, String facetRuntimeVersion, String facetID, String facetVersion) {
        if (this.descriptors == null) {
            this.readDescriptors();
        }
        for (MappingDescriptor descriptor : this.descriptors) {
            if (!RuntimePresetMappingRegistry.matches(facetRuntimeTypeID, descriptor.getFacetRuntimeTypeID()) || !RuntimePresetMappingRegistry.matches(facetRuntimeVersion, descriptor.getFacetRuntimeVersion()) || !RuntimePresetMappingRegistry.matches(facetID, descriptor.getFacetID()) || !RuntimePresetMappingRegistry.matches(facetVersion, descriptor.getFacetVersion())) continue;
            return descriptor.getPresetID();
        }
        return null;
    }

    private static boolean matches(String value, String pattern) {
        StringTokenizer strTok = new StringTokenizer(pattern, ",");
        while (strTok.hasMoreTokens()) {
            String simplePattern = strTok.nextToken().trim();
            if (simplePattern.startsWith("*")) {
                if (simplePattern.length() < 2) {
                    return true;
                }
                if (simplePattern.endsWith("*")) {
                    if (simplePattern.length() < 3) {
                        return true;
                    }
                    if (value.indexOf(simplePattern.substring(1, simplePattern.length() - 2)) == -1) continue;
                    return true;
                }
                if (!value.endsWith(simplePattern.substring(1))) continue;
                return true;
            }
            if (!(simplePattern.endsWith("*") ? value.startsWith(simplePattern.substring(0, simplePattern.length() - 2)) : value.equals(simplePattern))) continue;
            return true;
        }
        return false;
    }

    private static List<String> getStaticTokens(String pattern) {
        ArrayList<String> staticTokens = new ArrayList<String>();
        StringTokenizer strTok = new StringTokenizer(pattern, ",");
        while (strTok.hasMoreTokens()) {
            String simplePattern = strTok.nextToken().trim();
            if (simplePattern.startsWith("*") || simplePattern.endsWith("*")) continue;
            staticTokens.add(simplePattern);
        }
        return staticTokens;
    }

    private void readDescriptors() {
        this.descriptors = new ArrayList<MappingDescriptor>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.web", EXTENSION_POINT);
        if (point == null) {
            return;
        }
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            block39: {
                IConfigurationElement element = elements[i];
                if (ELEMENT_MAPPING.equals(element.getName())) {
                    String id = element.getAttribute(ATTRIBUTE_ID);
                    if (id == null || id.trim().length() == 0) {
                        WSTWebPlugin.logError("Extension: runtimePresetMappings Element: mapping is missing attribute id");
                    } else {
                        String runtimeID = element.getAttribute(ATTRIBUTE_FACET_RUNTIME_TYPE_ID);
                        if (runtimeID == null || runtimeID.trim().length() == 0) {
                            WSTWebPlugin.logError("Extension: runtimePresetMappings Element: mapping is missing attribute facetRuntimeTypeID");
                        } else {
                            List<String> staticRuntimeIDs = RuntimePresetMappingRegistry.getStaticTokens(runtimeID);
                            ArrayList<IRuntimeComponentType> staticRuntimeTypes = new ArrayList<IRuntimeComponentType>();
                            for (String staticRuntimeID : staticRuntimeIDs) {
                                try {
                                    IRuntimeComponentType runtimeType = RuntimeManager.getRuntimeComponentType((String)staticRuntimeID);
                                    if (runtimeType == null) continue;
                                    staticRuntimeTypes.add(runtimeType);
                                }
                                catch (IllegalArgumentException e) {
                                    WSTWebPlugin.logError("Extension: runtimePresetMappings Element: mapping defined invalid attribute facetRuntimeTypeID: " + runtimeID + " unable to resolve runtime: " + staticRuntimeID, e);
                                }
                            }
                            String runtimeVersionStr = element.getAttribute(ATTRIBUTE_FACET_RUNTIME_VERSION);
                            if (runtimeVersionStr == null || runtimeVersionStr.trim().length() == 0) {
                                WSTWebPlugin.logError("Extension: runtimePresetMappings Element: mapping is missing attribute facetRuntimeVersion");
                            } else {
                                String facetID;
                                if (!staticRuntimeTypes.isEmpty()) {
                                    List<String> staticRuntimeVersions = RuntimePresetMappingRegistry.getStaticTokens(runtimeVersionStr);
                                    for (String staticVersion : staticRuntimeVersions) {
                                        boolean foundVersion = false;
                                        int k = 0;
                                        while (k < staticRuntimeTypes.size() && !foundVersion) {
                                            IRuntimeComponentType runtimeType = (IRuntimeComponentType)staticRuntimeTypes.get(k);
                                            try {
                                                runtimeType.getVersion(staticVersion);
                                                foundVersion = true;
                                            }
                                            catch (IllegalArgumentException illegalArgumentException) {}
                                            ++k;
                                        }
                                        if (foundVersion) continue;
                                        StringBuffer validVersions = new StringBuffer(" valid versions include: ");
                                        for (IRuntimeComponentType runtimeType : staticRuntimeTypes) {
                                            validVersions.append("\n");
                                            validVersions.append(runtimeType.getId());
                                            validVersions.append(": ");
                                            Iterator iterator = runtimeType.getVersions().iterator();
                                            while (iterator.hasNext()) {
                                                validVersions.append(((IRuntimeComponentVersion)iterator.next()).getVersionString());
                                                if (!iterator.hasNext()) continue;
                                                validVersions.append(" ");
                                            }
                                        }
                                        WSTWebPlugin.logError("Extension: runtimePresetMappings Element: mapping defined invalid attribute facetRuntimeVersion: " + staticVersion + validVersions);
                                    }
                                }
                                if ((facetID = element.getAttribute(ATTRIBUTE_FACET_ID)) == null || facetID.trim().length() == 0) {
                                    WSTWebPlugin.logError("Extension: runtimePresetMappings Element: mapping is missing attribute facetID");
                                } else {
                                    List<String> staticFacetIDs = RuntimePresetMappingRegistry.getStaticTokens(facetID);
                                    ArrayList<IProjectFacet> staticFacets = new ArrayList<IProjectFacet>();
                                    for (String staticFacetID : staticFacetIDs) {
                                        try {
                                            IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)staticFacetID);
                                            if (facet == null) continue;
                                            staticFacets.add(facet);
                                        }
                                        catch (IllegalArgumentException e) {
                                            WSTWebPlugin.logError("Extension: runtimePresetMappings Element: mapping defined invalid attribute facetID: " + staticFacetID, e);
                                        }
                                    }
                                    String facetVersionStr = element.getAttribute(ATTRIBUTE_FACET_VERSION);
                                    if (facetVersionStr == null || facetVersionStr.trim().length() == 0) {
                                        WSTWebPlugin.logError("Extension: runtimePresetMappings Element: mapping is missing attribute facetVersion");
                                    } else {
                                        String presetID;
                                        List<String> staticFacetVersionStrs = RuntimePresetMappingRegistry.getStaticTokens(facetVersionStr);
                                        if (!staticFacets.isEmpty() && !staticFacetVersionStrs.isEmpty()) {
                                            for (String staticFacetVersion : staticFacetVersionStrs) {
                                                boolean foundFacetVersion = false;
                                                int k = 0;
                                                while (k < staticFacets.size() && !foundFacetVersion) {
                                                    IProjectFacet staticFacet = (IProjectFacet)staticFacets.get(k);
                                                    try {
                                                        IProjectFacetVersion staticVersion = staticFacet.getVersion(staticFacetVersion);
                                                        if (staticVersion != null) {
                                                            foundFacetVersion = true;
                                                        }
                                                    }
                                                    catch (IllegalArgumentException illegalArgumentException) {}
                                                    ++k;
                                                }
                                                if (foundFacetVersion) continue;
                                                StringBuffer validVersions = new StringBuffer(" valid versions include: ");
                                                for (IProjectFacet staticFacet : staticFacets) {
                                                    validVersions.append("\n");
                                                    validVersions.append(staticFacet.getId());
                                                    validVersions.append(": ");
                                                    Iterator iterator = staticFacet.getVersions().iterator();
                                                    while (iterator.hasNext()) {
                                                        validVersions.append(((IProjectFacetVersion)iterator.next()).getVersionString());
                                                        if (!iterator.hasNext()) continue;
                                                        validVersions.append(" ");
                                                    }
                                                }
                                                WSTWebPlugin.logError("Extension: runtimePresetMappings Element: mapping defined invalid attribute facetVersion: " + staticFacetVersion + validVersions);
                                            }
                                        }
                                        if ((presetID = element.getAttribute(ATTRIBUTE_PRESET_ID)) == null || presetID.trim().length() == 0) {
                                            WSTWebPlugin.logError("Extension: runtimePresetMappings Element: mapping is missing attribute presetID");
                                        } else {
                                            try {
                                                ProjectFacetsManager.getPreset((String)presetID);
                                            }
                                            catch (IllegalArgumentException e) {
                                                WSTWebPlugin.logError("Extension: runtimePresetMappings Element: mapping defined invalid attribute presetID: " + presetID, e);
                                                break block39;
                                            }
                                            MappingDescriptor descriptor = new MappingDescriptor(element);
                                            this.descriptors.add(descriptor);
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else {
                    WSTWebPlugin.logError("Elements must be named: mapping within the extension: runtimePresetMappings");
                    WSTWebPlugin.logError("Element: " + element.getName() + " is invalid within the extension: " + EXTENSION_POINT);
                }
            }
            ++i;
        }
    }
}

