/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;

public class ContentAssistProcessor
implements IContentAssistProcessor {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.ui/debug/ResultCollector"));
    private static final String PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY = "EmptyDefaultAssistCategory";
    private static final Comparator ORDER_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            CompletionProposalCategory d1 = (CompletionProposalCategory)o1;
            CompletionProposalCategory d2 = (CompletionProposalCategory)o2;
            return d1.getSortOrder() - d2.getSortOrder();
        }
    };
    private final List fCategories;
    private final String fPartition;
    private final ContentAssistant fAssistant;
    private char[] fCompletionAutoActivationCharacters;
    private int fRepetition = -1;
    private List fCategoryIteration = null;
    private String fIterationGesture = null;
    private int fNumberOfComputedResults = 0;
    private String fErrorMessage;

    public ContentAssistProcessor(ContentAssistant assistant, String partition) {
        Assert.isNotNull((Object)partition);
        Assert.isNotNull((Object)assistant);
        this.fPartition = partition;
        this.fCategories = CompletionProposalComputerRegistry.getDefault().getProposalCategories();
        this.fAssistant = assistant;
        this.fAssistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionStarted(ContentAssistEvent event) {
                if (event.processor != ContentAssistProcessor.this) {
                    return;
                }
                ContentAssistProcessor.this.fIterationGesture = ContentAssistProcessor.this.getIterationGesture();
                KeySequence binding = ContentAssistProcessor.this.getIterationBinding();
                ContentAssistProcessor.this.fCategoryIteration = ContentAssistProcessor.this.getCategoryIteration();
                for (CompletionProposalCategory cat : ContentAssistProcessor.this.fCategories) {
                    cat.sessionStarted();
                }
                ContentAssistProcessor.this.fRepetition = 0;
                if (event.assistant instanceof IContentAssistantExtension2) {
                    IContentAssistantExtension2 extension = (IContentAssistantExtension2)event.assistant;
                    if (ContentAssistProcessor.this.fCategoryIteration.size() == 1) {
                        extension.setRepeatedInvocationMode(false);
                        extension.setShowEmptyList(false);
                    } else {
                        extension.setRepeatedInvocationMode(true);
                        extension.setStatusLineVisible(true);
                        extension.setStatusMessage(ContentAssistProcessor.this.createIterationMessage());
                        extension.setShowEmptyList(true);
                        if (extension instanceof IContentAssistantExtension3) {
                            IContentAssistantExtension3 ext3 = (IContentAssistantExtension3)extension;
                            ((ContentAssistant)ext3).setRepeatedInvocationTrigger(binding);
                        }
                    }
                }
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                if (event.processor != ContentAssistProcessor.this) {
                    return;
                }
                for (CompletionProposalCategory cat : ContentAssistProcessor.this.fCategories) {
                    cat.sessionEnded();
                }
                ContentAssistProcessor.this.fCategoryIteration = null;
                ContentAssistProcessor.this.fRepetition = -1;
                ContentAssistProcessor.this.fIterationGesture = null;
                if (event.assistant instanceof IContentAssistantExtension2) {
                    IContentAssistantExtension2 extension = (IContentAssistantExtension2)event.assistant;
                    extension.setShowEmptyList(false);
                    extension.setRepeatedInvocationMode(false);
                    extension.setStatusLineVisible(false);
                    if (extension instanceof IContentAssistantExtension3) {
                        IContentAssistantExtension3 ext3 = (IContentAssistantExtension3)extension;
                        ((ContentAssistant)ext3).setRepeatedInvocationTrigger(null);
                    }
                }
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }
        });
    }

    public final ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        long start = DEBUG ? System.currentTimeMillis() : 0L;
        this.clearState();
        IProgressMonitor monitor = this.createProgressMonitor();
        monitor.beginTask(JavaTextMessages.ContentAssistProcessor_computing_proposals, this.fCategories.size() + 1);
        ContentAssistInvocationContext context = this.createContext(viewer, offset);
        long setup = DEBUG ? System.currentTimeMillis() : 0L;
        monitor.subTask(JavaTextMessages.ContentAssistProcessor_collecting_proposals);
        List proposals = this.collectProposals(viewer, offset, monitor, context);
        long collect = DEBUG ? System.currentTimeMillis() : 0L;
        monitor.subTask(JavaTextMessages.ContentAssistProcessor_sorting_proposals);
        List filtered = this.filterAndSortProposals(proposals, monitor, context);
        this.fNumberOfComputedResults = filtered.size();
        long filter = DEBUG ? System.currentTimeMillis() : 0L;
        ICompletionProposal[] result = filtered.toArray(new ICompletionProposal[filtered.size()]);
        monitor.done();
        if (DEBUG) {
            System.err.println("Code Assist Stats (" + result.length + " proposals)");
            System.err.println("Code Assist (setup):\t" + (setup - start));
            System.err.println("Code Assist (collect):\t" + (collect - setup));
            System.err.println("Code Assist (sort):\t" + (filter - collect));
        }
        return result;
    }

    private void clearState() {
        this.fErrorMessage = null;
        this.fNumberOfComputedResults = 0;
    }

    private List collectProposals(ITextViewer viewer, int offset, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        ArrayList proposals = new ArrayList();
        List providers = this.getCategories();
        for (CompletionProposalCategory cat : providers) {
            List computed = cat.computeCompletionProposals(context, this.fPartition, new SubProgressMonitor(monitor, 1));
            proposals.addAll(computed);
            if (this.fErrorMessage != null) continue;
            this.fErrorMessage = cat.getErrorMessage();
        }
        return proposals;
    }

    protected List filterAndSortProposals(List proposals, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        this.clearState();
        IProgressMonitor monitor = this.createProgressMonitor();
        monitor.beginTask(JavaTextMessages.ContentAssistProcessor_computing_contexts, this.fCategories.size() + 1);
        monitor.subTask(JavaTextMessages.ContentAssistProcessor_collecting_contexts);
        List proposals = this.collectContextInformation(viewer, offset, monitor);
        monitor.subTask(JavaTextMessages.ContentAssistProcessor_sorting_contexts);
        List filtered = this.filterAndSortContextInformation(proposals, monitor);
        this.fNumberOfComputedResults = filtered.size();
        IContextInformation[] result = filtered.toArray(new IContextInformation[filtered.size()]);
        monitor.done();
        return result;
    }

    private List collectContextInformation(ITextViewer viewer, int offset, IProgressMonitor monitor) {
        ArrayList proposals = new ArrayList();
        ContentAssistInvocationContext context = this.createContext(viewer, offset);
        List providers = this.getCategories();
        for (CompletionProposalCategory cat : providers) {
            List computed = cat.computeContextInformation(context, this.fPartition, new SubProgressMonitor(monitor, 1));
            proposals.addAll(computed);
            if (this.fErrorMessage != null) continue;
            this.fErrorMessage = cat.getErrorMessage();
        }
        return proposals;
    }

    protected List filterAndSortContextInformation(List contexts, IProgressMonitor monitor) {
        return contexts;
    }

    public final void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fCompletionAutoActivationCharacters = activationSet;
    }

    public final char[] getCompletionProposalAutoActivationCharacters() {
        return this.fCompletionAutoActivationCharacters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        if (this.fNumberOfComputedResults > 0) {
            return null;
        }
        if (this.fErrorMessage != null) {
            return this.fErrorMessage;
        }
        return JavaUIMessages.JavaEditor_codeassist_noCompletions;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    protected IProgressMonitor createProgressMonitor() {
        return new NullProgressMonitor();
    }

    protected ContentAssistInvocationContext createContext(ITextViewer viewer, int offset) {
        return new ContentAssistInvocationContext(viewer, offset);
    }

    private List getCategories() {
        if (this.fCategoryIteration == null) {
            return this.fCategories;
        }
        int iteration = this.fRepetition % this.fCategoryIteration.size();
        this.fAssistant.setStatusMessage(this.createIterationMessage());
        this.fAssistant.setEmptyMessage(this.createEmptyMessage());
        ++this.fRepetition;
        return (List)this.fCategoryIteration.get(iteration);
    }

    private List getCategoryIteration() {
        ArrayList<List<CompletionProposalCategory>> sequence = new ArrayList<List<CompletionProposalCategory>>();
        sequence.add(this.getDefaultCategories());
        for (CompletionProposalCategory cat : this.getSeparateCategories()) {
            sequence.add(Collections.singletonList(cat));
        }
        return sequence;
    }

    private List getDefaultCategories() {
        List included = this.getDefaultCategoriesUnchecked();
        if (("__java_javadoc".equals(this.fPartition) || "__dftl_partition_content_type".equals(this.fPartition)) && included.isEmpty() && !this.fCategories.isEmpty() && this.informUserAboutEmptyDefaultCategory()) {
            included = this.getDefaultCategoriesUnchecked();
        }
        return included;
    }

    private List getDefaultCategoriesUnchecked() {
        ArrayList<CompletionProposalCategory> included = new ArrayList<CompletionProposalCategory>();
        for (CompletionProposalCategory category : this.fCategories) {
            if (!category.isIncluded() || !category.hasComputers(this.fPartition)) continue;
            included.add(category);
        }
        return included;
    }

    private boolean informUserAboutEmptyDefaultCategory() {
        String linkMessage;
        String restoreButtonLabel;
        String message;
        String title;
        Shell shell;
        OptionalMessageDialog dialog;
        int returnValue;
        if (OptionalMessageDialog.isDialogEnabled(PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY) && (1034 == (returnValue = (dialog = new OptionalMessageDialog(PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY, shell = JavaScriptPlugin.getActiveWorkbenchShell(), title = JavaTextMessages.ContentAssistProcessor_all_disabled_title, null, message = JavaTextMessages.ContentAssistProcessor_all_disabled_message, 4, new String[]{restoreButtonLabel = JFaceResources.getString((String)"defaults"), IDialogConstants.CLOSE_LABEL}, 1, linkMessage = Messages.format(JavaTextMessages.ContentAssistProcessor_all_disabled_preference_link, LegacyActionTools.removeMnemonics((String)restoreButtonLabel)), restoreButtonLabel){
            private final /* synthetic */ String val$linkMessage;
            private final /* synthetic */ String val$restoreButtonLabel;
            {
                this.val$linkMessage = string;
                this.val$restoreButtonLabel = string2;
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5, $anonymous6, $anonymous7);
            }

            @Override
            protected Control createCustomArea(Composite composite) {
                Composite parent = new Composite(composite, 0);
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.verticalSpacing = 0;
                parent.setLayout((Layout)layout);
                Composite linkComposite = new Composite(parent, 0);
                layout = new GridLayout();
                layout.marginHeight = this.convertVerticalDLUsToPixels(7);
                layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
                layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
                linkComposite.setLayout((Layout)layout);
                Link link = new Link(linkComposite, 0);
                link.setText(this.val$linkMessage);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.setReturnCode(1035);
                        this.close();
                    }
                });
                GridData gridData = new GridData(4, 1, true, false);
                gridData.widthHint = this.getMinimumMessageWidth();
                link.setLayoutData((Object)gridData);
                super.createCustomArea(parent);
                return parent;
            }

            protected void createButtonsForButtonBar(Composite parent) {
                Button[] buttons = new Button[]{this.createButton(parent, 1034, this.val$restoreButtonLabel, false), this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true)};
                this.setButtons(buttons);
            }
        }).open()) || 1035 == returnValue)) {
            if (1034 == returnValue) {
                IPreferenceStore store = JavaScriptPlugin.getDefault().getPreferenceStore();
                store.setToDefault("content_assist_category_order");
                store.setToDefault("content_assist_disabled_computers");
            }
            if (1035 == returnValue) {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.wst.jsdt.ui.preferences.CodeAssistPreferenceAdvanced", null, null).open();
            }
            CompletionProposalComputerRegistry registry = CompletionProposalComputerRegistry.getDefault();
            registry.reload();
            return true;
        }
        return false;
    }

    private List getSeparateCategories() {
        ArrayList<CompletionProposalCategory> sorted = new ArrayList<CompletionProposalCategory>();
        for (CompletionProposalCategory category : this.fCategories) {
            if (!category.isSeparateCommand() || !category.hasComputers(this.fPartition)) continue;
            sorted.add(category);
        }
        Collections.sort(sorted, ORDER_COMPARATOR);
        return sorted;
    }

    private String createEmptyMessage() {
        return Messages.format(JavaTextMessages.ContentAssistProcessor_empty_message, new String[]{this.getCategoryLabel(this.fRepetition)});
    }

    private String createIterationMessage() {
        return Messages.format(JavaTextMessages.ContentAssistProcessor_toggle_affordance_update_message, new String[]{this.getCategoryLabel(this.fRepetition), this.fIterationGesture, this.getCategoryLabel(this.fRepetition + 1)});
    }

    private String getCategoryLabel(int repetition) {
        int iteration = repetition % this.fCategoryIteration.size();
        if (iteration == 0) {
            return JavaTextMessages.ContentAssistProcessor_defaultProposalCategory;
        }
        return this.toString((CompletionProposalCategory)((List)this.fCategoryIteration.get(iteration)).get(0));
    }

    private String toString(CompletionProposalCategory category) {
        return category.getDisplayName();
    }

    private String getIterationGesture() {
        KeySequence binding = this.getIterationBinding();
        return binding != null ? Messages.format(JavaTextMessages.ContentAssistProcessor_toggle_affordance_press_gesture, new Object[]{binding.format()}) : JavaTextMessages.ContentAssistProcessor_toggle_affordance_click_gesture;
    }

    private KeySequence getIterationBinding() {
        IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence binding = bindingSvc.getBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (binding instanceof KeySequence) {
            return (KeySequence)binding;
        }
        return null;
    }
}

