/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.ConnectionLogger;
import org.eclipse.wst.jsdt.chromium.internal.websocket.AbstractWsConnection;
import org.eclipse.wst.jsdt.chromium.internal.websocket.Hybi17Handshake;
import org.eclipse.wst.jsdt.chromium.internal.websocket.ManualLoggingSocketWrapper;
import org.eclipse.wst.jsdt.chromium.internal.websocket.WsConnection;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;

public class Hybi17WsConnection
extends AbstractWsConnection<ManualLoggingSocketWrapper.LoggableInput, ManualLoggingSocketWrapper.LoggableOutput> {
    private static final Logger LOGGER = Logger.getLogger(Hybi17WsConnection.class.getName());
    private static final Random RANDOM = new Random();
    private final MaskStrategy maskStrategy;
    private static final Hybi17Handshake.Result.Visitor<DataOrException<Void>> HANDSHAKE_RESULT_VISITOR = new Hybi17Handshake.Result.Visitor<DataOrException<Void>>(){

        @Override
        public DataOrException<Void> visitConnected() {
            return new DataOrException<Void>(){

                @Override
                Void get() throws IOException {
                    return null;
                }
            };
        }

        @Override
        public DataOrException<Void> visitUnknownError(final Exception exception) {
            return new DataOrException<Void>(){

                @Override
                Void get() throws IOException {
                    throw new IOException("Failed to establish WebSocket connection", exception);
                }
            };
        }

        @Override
        public DataOrException<Void> visitErrorMessage(final int code, final String errorName, final String text) {
            return new DataOrException<Void>(){

                @Override
                Void get() throws IOException {
                    throw new IOException("Failed to establish WebSocket connection: " + code + " " + errorName + " | " + text);
                }
            };
        }
    };
    private static final int STATUS_CODE_LENTGH = 2;

    public static Hybi17WsConnection connect(InetSocketAddress endpoint, int timeout, String resourceId, MaskStrategy maskStrategy, ConnectionLogger connectionLogger) throws IOException {
        ManualLoggingSocketWrapper socketWrapper = new ManualLoggingSocketWrapper(endpoint, timeout, connectionLogger, maskStrategy.getLogWrapperFactory());
        boolean handshakeDone = false;
        Exception handshakeException = null;
        try {
            try {
                Hybi17WsConnection.performHandshakeOrFail(socketWrapper, endpoint, resourceId);
                handshakeDone = true;
            }
            catch (RuntimeException e) {
                handshakeException = e;
                throw e;
            }
            catch (IOException e) {
                handshakeException = e;
                throw e;
            }
        }
        finally {
            if (!handshakeDone) {
                socketWrapper.getShutdownRelay().sendSignal(null, handshakeException);
            }
        }
        return new Hybi17WsConnection(socketWrapper, maskStrategy, connectionLogger);
    }

    private Hybi17WsConnection(ManualLoggingSocketWrapper socketWrapper, MaskStrategy maskStrategy, ConnectionLogger connectionLogger) {
        super(socketWrapper, connectionLogger);
        this.maskStrategy = maskStrategy;
    }

    @Override
    public void sendTextualMessage(final String message) throws IOException {
        final byte[] bytes = message.getBytes(UTF_8_CHARSET);
        LoggablePayload payload = new LoggablePayload(){

            @Override
            void send(ManualLoggingSocketWrapper.LoggableOutput output, byte[] maskBytes) throws IOException {
                output.writeToLog(message, "utf-8 demasked");
                if (maskBytes != null) {
                    int i = 0;
                    while (i < bytes.length) {
                        bytes[i] = (byte)(bytes[i] ^ maskBytes[i % 4]);
                        ++i;
                    }
                }
                output.writeBytesNoLogging(bytes);
            }

            @Override
            int getLength() {
                return bytes.length;
            }
        };
        this.sendMessage(1, payload, false);
    }

    @Override
    protected AbstractWsConnection.CloseReason runListenLoop(ManualLoggingSocketWrapper.LoggableInput loggableReader) throws IOException, InterruptedException {
        try {
            return this.runListenLoopImpl(loggableReader);
        }
        catch (IOException e) {
            String stackTrace = BasicUtil.getStacktraceString((Exception)e);
            try {
                this.sendClosingMessage(1002, stackTrace);
            }
            catch (IOException iOException) {}
            throw new IOException(e);
        }
        catch (IncomingProtocolException e) {
            String stackTrace = BasicUtil.getStacktraceString((Exception)e);
            this.sendClosingMessage(e.getStatusCode(), stackTrace);
            throw new IOException(e);
        }
    }

    private AbstractWsConnection.CloseReason runListenLoopImpl(ManualLoggingSocketWrapper.LoggableInput loggableReader) throws IOException, InterruptedException, IncomingProtocolException {
        while (true) {
            int payloadLen;
            boolean hasMask;
            IncomingFrameHandler frameHandler;
            int firstByte;
            loggableReader.markSeparatorForLog();
            try {
                firstByte = loggableReader.readByteOrEos();
            }
            catch (IOException e) {
                if (this.isClosingGracefully()) {
                    return AbstractWsConnection.CloseReason.USER_REQUEST;
                }
                throw e;
            }
            if (firstByte == -1) {
                if (this.isClosingGracefully()) {
                    return AbstractWsConnection.CloseReason.USER_REQUEST;
                }
                return AbstractWsConnection.CloseReason.REMOTE_SILENTLY_CLOSED;
            }
            if ((firstByte & 0x80) == 0) {
                throw new IncomingProtocolException("Fragments unsupported", 1003, null);
            }
            if ((firstByte & 0x70) != 0) {
                throw new IncomingProtocolException("Unexpected reserved bits", 1002, null);
            }
            int opcode = firstByte & 0xF;
            switch (opcode) {
                case 0: {
                    throw new IncomingProtocolException("Continuation is not supported", 1003, null);
                }
                case 1: {
                    frameHandler = IncomingFrameHandler.TEXT_MESSAGE;
                    break;
                }
                case 2: {
                    throw new IncomingProtocolException("Binary is not supported", 1003, null);
                }
                case 8: {
                    this.sendClosingMessage(1000, null);
                    return AbstractWsConnection.CloseReason.REMOTE_CLOSE_REQUEST;
                }
                case 9: {
                    frameHandler = IncomingFrameHandler.PING;
                    break;
                }
                case 10: {
                    frameHandler = IncomingFrameHandler.PONG;
                    break;
                }
                default: {
                    throw new IncomingProtocolException("Unsupported opcode " + opcode, 1003, null);
                }
            }
            int secondByte = Hybi17WsConnection.readByteOfFail(loggableReader);
            boolean bl = hasMask = (secondByte & 0x80) != 0;
            if (hasMask) {
                throw new IncomingProtocolException("Masked server-to-client message is not supported", 1002, null);
            }
            int payloadLenByte = secondByte & 0x7F;
            if (payloadLenByte == 126) {
                int lengthTemp = Hybi17WsConnection.readByteOfFail(loggableReader);
                lengthTemp <<= 8;
                payloadLen = lengthTemp += Hybi17WsConnection.readByteOfFail(loggableReader);
            } else if (payloadLenByte == 127) {
                int i = 0;
                while (i < 4) {
                    int b = Hybi17WsConnection.readByteOfFail(loggableReader);
                    if (b != 0) {
                        throw new IncomingProtocolException("Payload length is too large", 1003, null);
                    }
                    ++i;
                }
                int lengthTemp = Hybi17WsConnection.readByteOfFail(loggableReader);
                if ((lengthTemp & 0x80) != 0) {
                    throw new IncomingProtocolException("Payload length is too large", 1003, null);
                }
                int i2 = 0;
                while (i2 < 3) {
                    lengthTemp <<= 8;
                    lengthTemp += Hybi17WsConnection.readByteOfFail(loggableReader);
                    ++i2;
                }
                payloadLen = lengthTemp;
            } else {
                payloadLen = payloadLenByte;
            }
            byte[] bytes = loggableReader.readBytes(payloadLen);
            frameHandler.process(bytes, this);
        }
    }

    private void sendClosingMessage(final int statusCode, final String message) throws IOException {
        final byte[] bytes = message == null ? new byte[]{} : message.getBytes(UTF_8_CHARSET);
        LoggablePayload payload = new LoggablePayload(){

            @Override
            void send(ManualLoggingSocketWrapper.LoggableOutput output, byte[] maskBytes) throws IOException {
                byte codeByte1 = (byte)(statusCode >> 8 & 0xFF);
                byte codeByte2 = (byte)(statusCode & 0xFF);
                byte codeByteMasked1 = codeByte1;
                byte codeByteMasked2 = codeByte2;
                if (maskBytes != null) {
                    codeByteMasked1 = (byte)(codeByteMasked1 ^ maskBytes[0]);
                    codeByteMasked2 = (byte)(codeByteMasked2 ^ maskBytes[1]);
                    int i = 0;
                    while (i < bytes.length) {
                        bytes[i] = (byte)(bytes[i] ^ maskBytes[(i + 2) % 4]);
                        ++i;
                    }
                }
                output.writeByteNoLogging(codeByteMasked1);
                output.writeByteNoLogging(codeByteMasked2);
                output.writeByteToLog(codeByte1);
                output.writeByteToLog(codeByte2);
                output.writeBytesNoLogging(bytes);
                output.writeToLog(message, "utf-8 demasked");
            }

            @Override
            int getLength() {
                return 2 + bytes.length;
            }
        };
        this.sendMessage(8, payload, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(int opCode, LoggablePayload loggablePayload, boolean isClosingMessage) throws IOException {
        int length = loggablePayload.getLength();
        ManualLoggingSocketWrapper.LoggableOutput output = (ManualLoggingSocketWrapper.LoggableOutput)this.getSocketWrapper().getLoggableOutput();
        byte[] maskBytes = this.maskStrategy.generate();
        Hybi17WsConnection hybi17WsConnection = this;
        synchronized (hybi17WsConnection) {
            int maskFlag;
            if (this.isOutputClosed()) {
                throw new IOException("WebSocket is already closed for output");
            }
            if (isClosingMessage) {
                this.setOutputClosed(true);
            }
            byte firstByte = -127;
            output.writeByte(firstByte);
            int n = maskFlag = maskBytes == null ? 0 : 128;
            if (length <= 125) {
                output.writeByte((byte)(length | maskFlag));
            } else if (length <= 32768) {
                output.writeByte((byte)(0x7E | maskFlag));
                output.writeByte((byte)(length >> 8 & 0xFF));
                output.writeByte((byte)(length & 0xFF));
            } else {
                output.writeByte((byte)(0x7F | maskFlag));
                output.writeByte((byte)0);
                output.writeByte((byte)0);
                output.writeByte((byte)0);
                output.writeByte((byte)0);
                output.writeByte((byte)(length >>> 24));
                output.writeByte((byte)(length >> 16 & 0xFF));
                output.writeByte((byte)(length >> 8 & 0xFF));
                output.writeByte((byte)(length & 0xFF));
            }
            if (maskBytes != null) {
                output.writeBytes(maskBytes);
            }
            loggablePayload.send(output, maskBytes);
        }
        output.markSeparatorForLog();
    }

    private static void performHandshakeOrFail(ManualLoggingSocketWrapper socket, InetSocketAddress endpoint, String resourceId) throws IOException {
        Hybi17Handshake.Result result = Hybi17Handshake.performHandshake(socket, endpoint, resourceId, RANDOM);
        result.accept(HANDSHAKE_RESULT_VISITOR).get();
    }

    private static int readByteOfFail(ManualLoggingSocketWrapper.LoggableInput loggableReader) throws IOException {
        int b = loggableReader.readByteOrEos();
        if (b == -1) {
            throw new IOException("Unexpected EOS");
        }
        return b;
    }

    private static abstract class DataOrException<T> {
        private DataOrException() {
        }

        abstract T get() throws IOException;
    }

    private static interface FrameBits {
        public static final int FIN_BIT = 128;
        public static final int MASK_BIT = 128;
        public static final int OPCODE_LENGTH = 4;
        public static final int OPCODE_MASK = 15;
        public static final int RESERVED_MASK = 112;
        public static final int LENGTH_MASK = 127;
        public static final int LENGTH_2_BYTE_CODE = 126;
        public static final int LENGTH_8_BYTE_CODE = 127;
        public static final int HIGH_BIT = 128;
        public static final int MAX_TWO_BYTE_INT = 32768;
    }

    private static abstract class IncomingFrameHandler {
        static final IncomingFrameHandler TEXT_MESSAGE = new IncomingFrameHandler(){

            @Override
            void process(byte[] bytes, Hybi17WsConnection hybiWsConnection) {
                final String text = new String(bytes, UTF_8_CHARSET);
                hybiWsConnection.getDispatchQueue().add(new AbstractWsConnection.MessageDispatcher(){

                    @Override
                    boolean dispatch(WsConnection.Listener userListener) {
                        userListener.textMessageRecieved(text);
                        return false;
                    }
                });
            }
        };
        static final IncomingFrameHandler PING = new IncomingFrameHandler(){

            @Override
            void process(final byte[] bytes, Hybi17WsConnection hybiWsConnection) {
                LoggablePayload payload = new LoggablePayload(){

                    @Override
                    void send(ManualLoggingSocketWrapper.LoggableOutput output, byte[] maskBytes) throws IOException {
                        output.writeBytesToLog(bytes);
                        if (maskBytes != null) {
                            int i = 0;
                            while (i < bytes.length) {
                                bytes[i] = (byte)(bytes[i] ^ maskBytes[i % 4]);
                                ++i;
                            }
                        }
                        output.writeBytes(bytes);
                        output.markSeparatorForLog();
                    }

                    @Override
                    int getLength() {
                        return bytes.length;
                    }
                };
                try {
                    hybiWsConnection.sendMessage(10, payload, false);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to send pong", e);
                }
            }
        };
        static final IncomingFrameHandler PONG = new IncomingFrameHandler(){

            @Override
            void process(byte[] bytes, Hybi17WsConnection hybiWsConnection) {
            }
        };

        private IncomingFrameHandler() {
        }

        abstract void process(byte[] var1, Hybi17WsConnection var2);
    }

    private static class IncomingProtocolException
    extends Exception {
        private final int statusCode;

        private IncomingProtocolException(String message, int statusCode, Throwable cause) {
            super(message, cause);
            this.statusCode = statusCode;
        }

        int getStatusCode() {
            return this.statusCode;
        }
    }

    private static abstract class LoggablePayload {
        private LoggablePayload() {
        }

        abstract void send(ManualLoggingSocketWrapper.LoggableOutput var1, byte[] var2) throws IOException;

        abstract int getLength();
    }

    public static enum MaskStrategy {
        NO_MASK{

            @Override
            public byte[] generate() {
                return null;
            }

            @Override
            ManualLoggingSocketWrapper.FactoryBase getLogWrapperFactory() {
                return ManualLoggingSocketWrapper.PLAIN_ASCII;
            }
        }
        ,
        TRANSPARENT_MASK{
            private final byte[] bytes = new byte[4];

            @Override
            public byte[] generate() {
                return this.bytes;
            }

            @Override
            ManualLoggingSocketWrapper.FactoryBase getLogWrapperFactory() {
                return ManualLoggingSocketWrapper.PLAIN_ASCII;
            }
        }
        ,
        NORMAL_MASK{

            @Override
            byte[] generate() {
                byte[] result = new byte[4];
                RANDOM.nextBytes(result);
                return result;
            }

            @Override
            ManualLoggingSocketWrapper.FactoryBase getLogWrapperFactory() {
                return ManualLoggingSocketWrapper.ANNOTATED;
            }
        };


        abstract byte[] generate();

        abstract ManualLoggingSocketWrapper.FactoryBase getLogWrapperFactory();
    }

    private static interface OpCode {
        public static final int CONTINUATION = 0;
        public static final int TEXT = 1;
        public static final int BINARY = 2;
        public static final int CLOSE = 8;
        public static final int PING = 9;
        public static final int PONG = 10;
    }

    private static interface StatusCode {
        public static final int NORMAL = 1000;
        public static final int PROTOCOL_ERROR = 1002;
        public static final int CANNOT_ACCEPT = 1003;
    }
}

