/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ProgressUtil {
    private static final int LAYOUT_TOTAL_STEPS = 1000;

    public static boolean layoutProgressPlan(Stage ... stages) {
        float totalWeight = 0.0f;
        Stage[] stageArray = stages;
        int n = stages.length;
        int n2 = 0;
        while (n2 < n) {
            Stage stage = stageArray[n2];
            totalWeight += stage.weight;
            ++n2;
        }
        float sum = 0.0f;
        int steps = 0;
        Stage[] stageArray2 = stages;
        int n3 = stages.length;
        int n4 = 0;
        while (n4 < n3) {
            Stage stage = stageArray2[n4];
            int nextSteps = (int)((sum += stage.weight) / totalWeight * 1000.0f);
            stage.workNumberForMonitor = nextSteps - steps;
            steps = nextSteps;
            ++n4;
        }
        return true;
    }

    public static class MonitorWrapper {
        private final IProgressMonitor progressMonitor;
        private final String defaultLabel;

        public MonitorWrapper(IProgressMonitor progressMonitor, String defaultLabel) {
            this.progressMonitor = progressMonitor;
            this.defaultLabel = defaultLabel;
        }

        public void beginTask() {
            this.progressMonitor.beginTask(this.defaultLabel, 1000);
        }

        public void setTaskName(String name) {
            if (name == null) {
                name = this.defaultLabel;
            }
            this.progressMonitor.setTaskName(name);
        }

        public void clearTaskName() {
            this.progressMonitor.setTaskName(this.defaultLabel);
        }

        public void worked(int work) {
            this.progressMonitor.worked(work);
        }

        public MonitorWrapper createSubMonitorWrapper(String label, int steps) {
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(this.progressMonitor, steps);
            return new MonitorWrapper((IProgressMonitor)subProgressMonitor, label);
        }

        public IProgressMonitor createSubMonitor(int steps) {
            return new SubProgressMonitor(this.progressMonitor, steps);
        }

        public void done() {
            this.clearTaskName();
            this.progressMonitor.done();
        }

        public boolean isCanceled() {
            return this.progressMonitor.isCanceled();
        }
    }

    public static class Stage {
        private final String name;
        private final float weight;
        private int workNumberForMonitor = 0;

        public Stage(String name, float weight) {
            this.name = name;
            this.weight = weight;
        }

        public void start(MonitorWrapper monitorWrapper) {
            monitorWrapper.setTaskName(this.name);
        }

        public void finish(MonitorWrapper monitorWrapper) {
            monitorWrapper.worked(this.workNumberForMonitor);
            monitorWrapper.clearTaskName();
        }

        public MonitorWrapper createSubMonitorWrapper(MonitorWrapper monitorWrapper) {
            return monitorWrapper.createSubMonitorWrapper(this.name, this.workNumberForMonitor);
        }

        public IProgressMonitor createSubMonitor(MonitorWrapper monitorWrapper) {
            return monitorWrapper.createSubMonitor(this.workNumberForMonitor);
        }
    }
}

