/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.editor.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.uml2.common.edit.command.ChangeCommand;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.editor.UMLEditorPlugin;
import org.eclipse.uml2.uml.editor.actions.UMLCommandAction;

public class CreateExtensionAction
extends UMLCommandAction {
    protected Command createActionCommand(EditingDomain editingDomain, Collection<?> collection) {
        if (collection.size() == 1 && collection.iterator().next() instanceof Stereotype) {
            return IdentityCommand.INSTANCE;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void run(IAction action) {
        if (this.command != UnexecutableCommand.INSTANCE) {
            final Stereotype stereotype = (Stereotype)this.collection.iterator().next();
            EList allExtendedMetaclasses = stereotype.getAllExtendedMetaclasses();
            ArrayList<Class> choiceOfValues = new ArrayList<Class>();
            Profile profile = stereotype.getProfile();
            if (profile != null) {
                for (Model referencedMetamodel : profile.getReferencedMetamodels()) {
                    for (Type ownedType : referencedMetamodel.getOwnedTypes()) {
                        Class ownedClass;
                        if (!(ownedType instanceof Class) || !(ownedClass = (Class)ownedType).isMetaclass() || allExtendedMetaclasses.contains((Object)ownedClass)) continue;
                        choiceOfValues.add(ownedClass);
                    }
                }
                for (Class referencedMetaclass : profile.getReferencedMetaclasses()) {
                    if (allExtendedMetaclasses.contains((Object)referencedMetaclass) || choiceOfValues.contains(referencedMetaclass)) continue;
                    choiceOfValues.add(referencedMetaclass);
                }
            }
            Collections.sort(choiceOfValues, new UMLCommandAction.TextComparator(this));
            String label = UMLEditorPlugin.INSTANCE.getString("_UI_CreateExtensionActionCommand_label");
            final FeatureEditorDialog dialog = new FeatureEditorDialog(this.workbenchPart.getSite().getShell(), this.getLabelProvider(), (Object)stereotype, (EClassifier)UMLPackage.Literals.STEREOTYPE, Collections.EMPTY_LIST, label, choiceOfValues, false, false, true);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.editingDomain, new Runnable(){

                    @Override
                    public void run() {
                        for (Object result : dialog.getResult()) {
                            stereotype.createExtension((Class)result, false);
                        }
                    }
                }, label));
            }
        }
    }
}

