/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.description.operations;

import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.ConditionalStyleDescription;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;

public final class ConditionalStyleSpecOperations {
    private ConditionalStyleSpecOperations() {
    }

    public static boolean checkPredicate(ConditionalStyleDescription style, EObject modelElement, EObject viewVariable, EObject containerVariable, DDiagram dDiagram) {
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(modelElement);
        return ConditionalStyleSpecOperations.checkPredicate(style, modelElement, viewVariable, containerVariable, dDiagram, interpreter);
    }

    public static boolean checkPredicate(ConditionalStyleDescription style, EObject modelElement, EObject viewVariable, EObject containerVariable, DDiagram dDiagram, IInterpreter interpreter) {
        LinkedHashSet<String> variablesToUnset = new LinkedHashSet<String>();
        if (viewVariable instanceof DDiagramElement) {
            EObject eContainer;
            interpreter.setVariable("diagram", (Object)dDiagram);
            variablesToUnset.add("diagram");
            interpreter.setVariable("view", (Object)viewVariable);
            variablesToUnset.add("view");
            if (viewVariable instanceof DEdge) {
                EdgeTarget sourceNode = ((DEdge)viewVariable).getSourceNode();
                EdgeTarget targetNode = ((DEdge)viewVariable).getTargetNode();
                interpreter.setVariable("sourceView", (Object)sourceNode);
                variablesToUnset.add("sourceView");
                interpreter.setVariable("targetView", (Object)targetNode);
                variablesToUnset.add("targetView");
            }
            if ((eContainer = viewVariable.eContainer()) != null) {
                interpreter.setVariable("containerView", (Object)eContainer);
                variablesToUnset.add("containerView");
                if (eContainer instanceof DSemanticDecorator) {
                    EObject semanticContainer = ((DSemanticDecorator)eContainer).getTarget();
                    interpreter.setVariable("container", (Object)semanticContainer);
                    variablesToUnset.add("container");
                }
            }
        }
        boolean result = false;
        try {
            result = RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateBoolean(modelElement, (EObject)style, (EStructuralFeature)DescriptionPackage.eINSTANCE.getConditionalStyleDescription_PredicateExpression());
        }
        catch (Throwable throwable) {
            variablesToUnset.forEach(arg_0 -> ((IInterpreter)interpreter).unSetVariable(arg_0));
            throw throwable;
        }
        variablesToUnset.forEach(arg_0 -> ((IInterpreter)interpreter).unSetVariable(arg_0));
        return result;
    }
}

