/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.ui.PHPUiPlugin;

public class ArchieveFileFilter
extends ViewerFilter {
    private List<IFile> fExcludes;
    private boolean fRecursive;
    private static String[] fFilterExtensions = new String[]{"*.zip", "*.jar"};

    public ArchieveFileFilter(IFile[] excludedFiles, boolean recusive, String[] filterExtensions) {
        this.fExcludes = excludedFiles != null ? Arrays.asList(excludedFiles) : null;
        this.fRecursive = recusive;
        fFilterExtensions = filterExtensions;
    }

    public ArchieveFileFilter(List<IFile> excludedFiles, boolean recusive, String[] filterExtensions) {
        this.fExcludes = excludedFiles;
        this.fRecursive = recusive;
        fFilterExtensions = filterExtensions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            if (this.fExcludes == null) return ArchieveFileFilter.isZipPath(((IFile)element).getFullPath());
            if (!this.fExcludes.contains(element)) return ArchieveFileFilter.isZipPath(((IFile)element).getFullPath());
            return false;
        }
        if (!(element instanceof IContainer)) return false;
        if (!this.fRecursive) {
            return true;
        }
        try {
            IResource[] resources = ((IContainer)element).members();
            int i = 0;
            while (true) {
                if (i >= resources.length) {
                    return false;
                }
                if (this.select(viewer, parent, resources[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PHPUiPlugin.log(e.getStatus());
        }
        return false;
    }

    public static boolean isZipPath(IPath path) {
        String ext = path.getFileExtension();
        if (ext != null && ext.length() != 0) {
            return ArchieveFileFilter.isArchiveFileExtension(ext);
        }
        return false;
    }

    public static boolean isArchiveFileExtension(String ext) {
        int i = 0;
        while (i < fFilterExtensions.length) {
            if (ext.equalsIgnoreCase(fFilterExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

