/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.delegate.ValidationBehavior;
import org.eclipse.ocl.ecore.opposites.DefaultOppositeEndFinder;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.eventmanager.EventManager;
import org.eclipse.ocl.examples.eventmanager.EventManagerFactory;
import org.eclipse.ocl.examples.impactanalyzer.ImpactAnalyzer;
import org.eclipse.ocl.examples.impactanalyzer.ImpactAnalyzerFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;

public abstract class Revalidator {
    private final EventManager eventManager;
    private final Collection<Adapter> adapters;
    private final OCLFactory oclFactory;
    private final OppositeEndFinder oppositeEndFinder;

    public Revalidator(ResourceSet resourceSet, OCLFactory oclFactory, EPackage ... pkgs) {
        this(resourceSet, oclFactory, (OppositeEndFinder)DefaultOppositeEndFinder.getInstance(), pkgs);
    }

    public Revalidator(ResourceSet resourceSet, EPackage ... pkgs) {
        this(resourceSet, OCLFactory.getInstance(), pkgs);
    }

    public Revalidator(ResourceSet resourceSet, OppositeEndFinder oppositeEndFinder, EPackage ... pkgs) {
        this(resourceSet, OCLFactory.getInstance(), oppositeEndFinder, pkgs);
    }

    public Revalidator(ResourceSet resourceSet, OCLFactory oclFactory, OppositeEndFinder oppositeEndFinder, EPackage ... pkgs) {
        this.eventManager = EventManagerFactory.eINSTANCE.createEventManagerFor(resourceSet);
        this.oclFactory = oclFactory;
        this.oppositeEndFinder = oppositeEndFinder;
        this.adapters = this.registerInvariants(pkgs);
    }

    private Collection<Adapter> registerInvariants(EPackage ... pkgs) {
        LinkedList<Adapter> result = new LinkedList<Adapter>();
        EPackage[] ePackageArray = pkgs;
        int n = pkgs.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage pkg = ePackageArray[n2];
            for (EClassifier cls : pkg.getEClassifiers()) {
                String[] constraintNames;
                String spaceSeparatedConstraintNames;
                EAnnotation ann = cls.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
                if (ann == null || (spaceSeparatedConstraintNames = (String)ann.getDetails().get((Object)"constraints")) == null) continue;
                String[] stringArray = constraintNames = spaceSeparatedConstraintNames.split(" ");
                int n3 = constraintNames.length;
                int n4 = 0;
                while (n4 < n3) {
                    String constraintName = stringArray[n4];
                    OCLExpression invariant = ValidationBehavior.INSTANCE.getInvariant(cls, constraintName, this.oclFactory.createOCL(this.oppositeEndFinder));
                    ImpactAnalyzer impactAnalyzer = ImpactAnalyzerFactory.INSTANCE.createImpactAnalyzer(invariant, true, this.oppositeEndFinder, this.oclFactory);
                    Adapter adapter = this.getAdapter(constraintName, invariant, impactAnalyzer);
                    result.add(adapter);
                    this.eventManager.subscribe(impactAnalyzer.createFilterForExpression(), adapter);
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    protected OCLFactory getOclFactory() {
        return this.oclFactory;
    }

    protected OppositeEndFinder getOppositeEndFinder() {
        return this.oppositeEndFinder;
    }

    protected abstract Adapter getAdapter(String var1, OCLExpression var2, ImpactAnalyzer var3);
}

