/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.actions;

import java.util.Collection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;

final class ExportInfo {
    private final IPrimitiveArray charArray;
    private final int offset;
    private final int count;
    private final Mode m;

    private ExportInfo(IPrimitiveArray charArray, int offset, int count, Mode m) {
        this.charArray = charArray;
        this.offset = offset;
        this.count = count;
        this.m = m;
    }

    public IPrimitiveArray getCharArray() {
        return this.charArray;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getCount() {
        return this.count;
    }

    public char[] getChars(int offset, int read) {
        if (this.m == Mode.LATIN1) {
            byte[] bytes = (byte[])this.charArray.getValueArray(offset, read);
            char[] array = new char[bytes.length];
            int i = 0;
            while (i < bytes.length) {
                array[i] = (char)bytes[i];
                ++i;
            }
            return array;
        }
        if (this.m == Mode.UTF16LITTLE) {
            byte[] bytes = (byte[])this.charArray.getValueArray(offset * 2, read * 2);
            char[] array = new char[bytes.length / 2];
            int i = 0;
            while (i < bytes.length) {
                array[i / 2] = (char)(bytes[i] & 0xFF | (bytes[i + 1] & 0xFF) << 8);
                i += 2;
            }
            return array;
        }
        if (this.m == Mode.UTF16BIG) {
            byte[] bytes = (byte[])this.charArray.getValueArray(offset * 2, read * 2);
            char[] array = new char[bytes.length / 2];
            int i = 0;
            while (i < bytes.length) {
                array[i / 2] = (char)(bytes[i + 1] & 0xFF | (bytes[i] & 0xFF) << 8);
                i += 2;
            }
            return array;
        }
        char[] array = (char[])this.charArray.getValueArray(offset, read);
        return array;
    }

    public int getLength() {
        if (this.m == Mode.UTF16BIG || this.m == Mode.UTF16LITTLE) {
            return this.charArray.getLength() / 2;
        }
        return this.charArray.getLength();
    }

    public static ExportInfo of(IObject object) throws SnapshotException {
        Mode m;
        Integer offset = 0;
        Integer count = 0;
        IPrimitiveArray charArray = null;
        if ("java.lang.String".equals(object.getClazz().getName())) {
            offset = (Integer)object.resolveValue("offset");
            count = (Integer)object.resolveValue("count");
            charArray = (IPrimitiveArray)object.resolveValue("value");
            if (offset == null) {
                offset = 0;
            }
            if (count == null && charArray != null) {
                count = charArray.getLength() - offset;
            }
        } else if ("char[]".equals(object.getClazz().getName())) {
            charArray = (IPrimitiveArray)object;
            count = charArray.getLength();
        } else if (object.getClazz().doesExtend("java.lang.AbstractStringBuilder")) {
            count = (Integer)object.resolveValue("count");
            charArray = (IPrimitiveArray)object.resolveValue("value");
        } else if (object.getClazz().doesExtend("java.io.StringWriter")) {
            count = (Integer)object.resolveValue("buf.count");
            charArray = (IPrimitiveArray)object.resolveValue("buf.value");
        } else {
            return null;
        }
        if (offset == null || count == null || charArray == null) {
            return null;
        }
        if (charArray.getType() == 5) {
            m = Mode.CHAR;
        } else if (charArray.getType() == 8) {
            Object o = object.resolveValue("coder");
            if (o instanceof Byte && (Byte)o != 0) {
                IClass str;
                Object shift;
                Collection clss = object.getSnapshot().getClassesByName("java.lang.StringUTF16", false);
                m = clss != null && !clss.isEmpty() ? ((shift = (str = (IClass)clss.iterator().next()).resolveValue("HI_BYTE_SHIFT")) instanceof Integer && (Integer)shift == 8 ? Mode.UTF16BIG : Mode.UTF16LITTLE) : Mode.UTF16LITTLE;
                count = Math.min(charArray.getLength() / 2 - offset, count);
            } else {
                m = Mode.LATIN1;
            }
        } else {
            return null;
        }
        return new ExportInfo(charArray, offset, count, m);
    }

    private static enum Mode {
        CHAR,
        LATIN1,
        UTF16BIG,
        UTF16LITTLE;

    }
}

