/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.ASMInterpreter;
import org.eclipse.m2m.atl.engine.vm.ASMOperation;
import org.eclipse.m2m.atl.engine.vm.ASMStackFrame;
import org.eclipse.m2m.atl.engine.vm.ASMXMLReader;
import org.eclipse.m2m.atl.engine.vm.AtlSuperimposeModule;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.SimpleDebugger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModule;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;

public final class AtlLauncher {
    private static AtlLauncher defaultLauncher;

    private AtlLauncher() {
    }

    public static AtlLauncher getDefault() {
        if (defaultLauncher == null) {
            defaultLauncher = new AtlLauncher();
        }
        return defaultLauncher;
    }

    public Object launch(URL asmurl, Map libraries, Map models, Map asmParams, List superimpose) {
        return this.launch(asmurl, libraries, models, asmParams, superimpose, Collections.EMPTY_MAP);
    }

    public Object launch(URL asmurl, Map libraries, Map models, Map asmParams, List superimpose, Map options) {
        return this.launch(asmurl, libraries, models, asmParams, superimpose, options, (Debugger)new SimpleDebugger("true".equals(options.get("step")), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), true, "true".equals(options.get("showSummary")), "true".equals(options.get("profile")), "true".equals(options.get("continueAfterError"))));
    }

    public Object launch(URL asmurl, Map libraries, Map models, Map asmParams, List superimpose, Map options, Debugger debugger) {
        try {
            ASM asm = new ASMXMLReader().read(new BufferedInputStream(asmurl.openStream()));
            return this.launch(asm, libraries, models, asmParams, superimpose, options, debugger);
        }
        catch (IOException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public Object launch(ASM asm, Map libraries, Map models, Map asmParams, List superimpose, Map options, Debugger debugger) {
        ASMOclAny ret = null;
        ASMModule asmModule = new ASMModule(asm);
        ASMExecEnv env = new ASMExecEnv(asmModule, debugger, !"true".equals(options.get("disableAttributeHelperCache")));
        env.addPermission("file.read");
        env.addPermission("file.write");
        for (String mname : models.keySet()) {
            env.addModel(mname, (ASMModel)models.get(mname));
        }
        try {
            for (String lname : libraries.keySet()) {
                ASM lib;
                Object libASMOrURL = libraries.get(lname);
                if (libASMOrURL instanceof URL) {
                    URL url = (URL)libASMOrURL;
                    lib = new ASMXMLReader().read(new BufferedInputStream(url.openStream()));
                } else {
                    lib = (ASM)libASMOrURL;
                }
                env.registerOperations(lib);
                ASMOperation op = lib.getOperation("main");
                if (op == null) continue;
                op.exec(ASMStackFrame.rootFrame(env, op, Arrays.asList(asmModule)));
            }
        }
        catch (IOException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        env.registerOperations(asm);
        try {
            for (URL url : superimpose) {
                ASM module = new ASMXMLReader().read(new BufferedInputStream(url.openStream()));
                AtlSuperimposeModule ami = new AtlSuperimposeModule(env, module);
                ami.adaptModuleOperations();
                env.registerOperations(module);
            }
        }
        catch (IOException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (AtlSuperimposeModule.AtlSuperimposeModuleException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        boolean printExecutionTime = "true".equals(options.get("printExecutionTime"));
        long startTime = System.currentTimeMillis();
        ASMInterpreter ai = new ASMInterpreter(asm, asmModule, env, asmParams);
        long endTime = System.currentTimeMillis();
        if (printExecutionTime && debugger instanceof SimpleDebugger) {
            ATLLogger.info((String)(String.valueOf(asm.getName()) + " executed in " + (double)(endTime - startTime) / 1000.0 + "s."));
        }
        ret = ai.getReturnValue();
        return ret;
    }
}

